/* $Id: wsPage.h,v 1.1 2001/05/30 13:38:55 mike Exp $ -*- C++ -*-
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __WSPAGE_H__
#define __WSPAGE_H__ 1

#include <ctime>

#include <iostream>
#include <fstream>
#include <string>

#include "wsDBObject.h"

namespace std
{
  class wsPage : public wsDBObject
  {
  public:
    wsPage(string);
    virtual ~wsPage(void) { }

    virtual int load(ifstream *);
    virtual int sync(int);
    virtual int make() = 0;
    virtual int clean();
    virtual int make(ofstream *) = 0;
    virtual int dump(ofstream *);

    virtual int nameIs(const string *name) const
    { return (this->name.compare(*name) == 0)?1:0; }

    virtual int nameBegins(const string *) const;
    virtual int nameEnds(const string *) const;
    virtual int nameHas(const string *) const;

    virtual void print(void) const;
    virtual void printWebPath(void) const;
    virtual void printSync(void);
 
  protected:
    void copyTo(wsPage *);

    int checkOutputDir(void);
    int checkOutputPageDir(void);
    int sourcePageExists(void) const;
    int outputPageExists(void) const;

    string getFullSourcePageDir(void) const;
    string getFullOutputPageDir(void) const;
    string getFullSourceDir(void) const;
    string getFullOutputDir(void) const;
    string getOutputPageDir(void) const;
    string getSourcePageDir(void) const;
    string getFullSourcePage(void) const;
    string getFullOutputPage(void) const;
    time_t getSourceLastMod(void) const;
    time_t getOutputLastMod(void) const;

    void setLastModByFile(void);
    void setPermissions(void);
    void setTime(void);
    void setName(string);
    void setSourceDir(string);
    void setOutputDir(string);
    void setConfigDir(string);
    void setSourcePage(string);
    void setOutputPage(string);

    inline void setLastMod(time_t)
    { this->last_mod = last_mod; }

    inline string getSourceDir(void) const
    { return source_dir; }

    inline string getOutputDir(void) const
    { return output_dir; }

    inline string getConfigDir(void) const
    { return config_dir; }

    inline string getSourcePage(void) const
    { return source_page; }

    inline string getOutputPage(void) const
    { return output_page; }

  private:
    static int getPageTagID(const string*);

    string name;
    string source_page;
    string output_page;
    string source_dir;
    string output_dir;
    string config_dir;
    time_t last_mod;
    int sync_printed;
  };
}

#endif /* __WSPAGE_H__ */
