/* $Id: wsDependList.cpp,v 1.1 2001/05/30 13:38:56 mike Exp $
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#include "wsDependList.h"

using namespace std;

wsDependList::wsDependList()
{
  DBGPRINT(("O:created: wsDependList\n"));
}

wsDependList::~wsDependList()
{
  DBGPRINT(("O:destroyed: wsDependList\n"));
}

void wsDependList::free()
{
  list< wsDepend * >::const_iterator i;

  for(i=dependlist.begin();i!=dependlist.end();++i) {
    (*i)->unref();
  }
}

int wsDependList::sync(int force)
{
  list< wsDepend * >::const_iterator i;

  for(i=dependlist.begin();i!=dependlist.end();++i) {
    (*i)->sync(force);
  }

  return 1;
}

int wsDependList::make(void)
{
  list< wsDepend * >::const_iterator i;

  for(i=dependlist.begin();i!=dependlist.end();++i) {
    (*i)->make();
  }

  return 1;
}

int wsDependList::pushBackDepend(wsDepend *depend)
{
  if(!depend) {
    return 0;        // Tried to insert a null depend
  }

  if(!defined(depend)) {
    dependlist.push_back(depend);
  }

  return 1;
}

int wsDependList::pushFrontDepend(wsDepend *depend)
{
  if(!depend) {
    return 0;        // Tried to insert a null depend
  }

  if(!defined(depend)) {
    dependlist.push_front(depend);
  }

  return 1;
}

bool wsDependList::isUpdated(void) const
{
  list< wsDepend * >::const_iterator i;

  for(i=dependlist.begin();i!=dependlist.end();++i) {
    if((*i)->isUpdated()) return true;
  }

  return false;
}  

wsDependList *wsDependList::operator+=(wsDependList *append_list)
{
  list< wsDepend * >::const_iterator i;
  for(i=append_list->dependlist.begin();
      i!=append_list->dependlist.end();++i) {
    this->pushBackDepend(*i);
  }

  return this;
}

int wsDependList::defined(const wsDepend *depend)
{
  list< wsDepend * >::const_iterator i;

  for(i=dependlist.begin();i!=dependlist.end();++i)
    if(*(*i) == depend) return 1;

  return 0;
}

void wsDependList::printNames(void)
{
  list< wsDepend * >::const_iterator i;

  __wsmake_print("[ ");
  for(i=dependlist.begin();i!=dependlist.end();++i) {
    (*i)->print();
    __wsmake_print(" ");
  }
  __wsmake_print("]");
}

void wsDependList::printNames(int debug)
{
  list< wsDepend * >::const_iterator i;

  __wsmake_print(debug,"[ ");
  for(i=dependlist.begin();i!=dependlist.end();++i) {
    (*i)->print(debug);
    __wsmake_print(debug, " ");
  }
  __wsmake_print(debug, "]");
}
