/* $Id: wsDepend.h,v 1.1 2001/05/30 13:38:56 mike Exp $ -*- C++ -*-
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __WSDEPEND_H__
#define __WSDEPEND_H__ 1

#include <string>

#include "wsDBObject.h"
#include "wsPageGroup.h"
#include "wsUtil.h"
#include "wsmake.h"

namespace std
{
  class wsDepend : wsDBObject
  {
  public:
    wsDepend(string, string, wsPageGroup *);
    ~wsDepend();

    int load(const string *);
    int sync(int);
    void make(void);
    int dump(ostream *);
    void print(void) const;
    void print(int) const;
    static wsDepend *findOrCreate(string, string, wsPageGroup *);

    inline bool isUpdated(void) const
    { return updated; }

    inline bool operator==(const string filename) const
    { return (filename == this->filename)?true:false; }

    inline bool operator==(const wsDepend *depend) const
    { return (depend->filename == this->filename)?true:false; }

    inline wsDepend *operator=(const string filename)
    { this->setFilename("", filename); return this; }

    inline wsDepend *operator=(const wsDepend *depend)
    { this->setFilename("", depend->filename); return this; }

    inline void ref(void)
    { ref_count++; }

    inline void unref(void)
    { if(--ref_count == 0) delete this; }

  protected:
    int pageExists(void);

    void setFilename(string, string);

    inline string getFilename(void) const
    { return filename; }

    time_t getLastMod(void) const;

    inline string getDatabaseKey(void) const
    { return KEY_DEPEND + this->getFilename(); }

  private:
    int ref_count;
    bool updated;
    string filename;
    wsPageGroup *pagegroup;
  };
}

#endif /* __WSDEPEND_H__ */
