/* $Id: wsDBObject.h,v 1.1 2001/05/30 13:38:55 mike Exp $ -*- C++ -*-
 ***********************************************************************
 *         libwsmake - Core functionality library of wsmake            *
 *           Copyright (C) 1999,2000,2001 Michael Brownlow             *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __WSDBOBJECT_H__
#define __WSDBOBJECT_H__ 1

#include <list>

#include "dba.h"
#include "wsUtil.h"

namespace std
{
  class wsDBObject
  {
  public:
    wsDBObject(void);
    wsDBObject(const char *, int);
    ~wsDBObject(void);

    int load(const char *, int);
    int close(void);

    inline bool ready(void)
    { return (this->dba == NULL)?false:true; }

  protected:
    void *getDatabaseValue(void *);
    char *getDatabaseKey(char *);

    void setDatabaseKey(const char *);
    void setDatabaseValue(const char *);
    void setDatabaseValue(long);
    inline void setValueType(int data_type)
    { this->type = data_type; }

    int dbKeyExists(const char *);

    static int keyInCache(const char *);
    static wsDBObject *dbobWithKey(const char *);

  private:
    static list< wsDBObject * > cache;
    char *key;
    int   type;
    int   exists;
    DBA  *dba;
  };
}

#endif /* __WSDBOBJECT_H__ */
