#include <stdio.h>
#include <assert.h>
#include <stdlib.h>

#include "dba.h"

#define MAXDB1 1024
#define DBTYPE DBA_DB_CSV

int main()
{
  int error, i, j, f;
  DBA *mydb[MAXDB1], *mydb2[MAXDB1];
  char *testvalue = NULL;
  char filename[20];

  printf("Starting test2\n");

  if((error=dba_init(0)) == 0) { /* returns 0 on success */

    for(i=0, f=MAXDB1;i<MAXDB1;i++, f--) {
      memset(filename,0,20);
      snprintf(filename, 20, "output/test%d.db",i);
      printf("Creating %s reference 1\r", filename);
      mydb[i] = dba_open(mydb[i], filename, DBTYPE);
      assert(mydb[i]);
      dba_add(mydb[i],DBA_DT_STRING,"key2","value2");
      dba_add(mydb[i],DBA_DT_STRING,"key1","value1");
      dba_add(mydb[i],DBA_DT_STRING,"key3","value3");
      dba_del(mydb[i], "key2");
      dba_del(mydb[i], "key3");
      /* making f inversely proportional here makes */
      /* for good marketing */
      for(j=0; j<f; j++) {
	printf("Creating %s reference %d\r", filename,j+1);
	mydb2[j] = dba_open(mydb2[j], filename, DBTYPE);
	assert(mydb2[j]);
	if((testvalue = dba_get(mydb2[j],DBA_DT_STRING,"key1",testvalue))
	   != NULL) {
	  assert(testvalue);
	  free(testvalue);
	  testvalue = NULL;
	}
      }
      for(j=0; j<f; j++) {
        	printf("Closing  %s reference %d\r", filename, j+1);
      	dba_close(mydb2[j]);
      }
      dba_close(mydb[i]);
    }
    printf("\n");

    printf("Freeing memory...\n");
    dba_exit();
  } else {
    printf("Failed to initialize libdba: error = %d\n", error);
  }

  printf("Finished test2\n");

  return 0;
}
