#include <stdio.h>
#include <assert.h>
#include <stdlib.h>

#include "dba.h"

#define DBTYPE DBA_DB_CSV

int main()
{
  int error;
  DBA *mydb = 0, *mydb2 = 0;
  char *testvalue = NULL;
  long testvalue2 = 0;

  printf("Starting test1\n");

  if((error=dba_init(1)) == 0) { /* returns 0 on success */

    printf("Creating test1.db...\n");
    mydb = dba_open(mydb, "test1.db", DBTYPE);

    if(mydb) {
      printf("Adding entry to test1: [%s:%s]\n", "key1", "value1");
      if(!dba_add(mydb, DBA_DT_STRING, "key1", "value1,stuff")) {
        printf("Failure to add entry\n");
        exit(1);
      }

      printf("Testing existence of new entry: ");
      if(dba_exists(mydb, "key1")) {
        printf("yes.\n");
      } else {
        printf("no.\n");
      }

      printf("Getting entry back from test1: ");
      if((testvalue = dba_get(mydb, DBA_DT_STRING, "key1", testvalue))
	 != NULL) {
	assert(testvalue);
        printf("[%s]\n", testvalue);
	free(testvalue);
	testvalue = NULL;
      } else {
        printf("value was NULL!\n");
      }

      printf("Take a peek at the database, then hit enter to contiune.");
      getc(stdin);

      printf("Creating test1.db again...\n");
      mydb2 = dba_open(mydb2, "test1.db", DBTYPE);
      if(mydb2) {
        
        printf("Setting previous entry through test2 (4234234)\n");
        if(!mydb2->set(mydb2, DBA_DT_LONG, "key1", 4234234)) {
          printf("Failure to set entry\n");
        }
        
        printf("Getting new entry back from test2: ");
        if((dba_get(mydb2, DBA_DT_LONG, "key1", &testvalue2)) != NULL) {
          printf("[%ld]\n", testvalue2);
        } else {
          printf("value was NULL!\n");
        }

        printf("Closing test1.db...\n");
        dba_close(mydb2);
      } else {
        printf("Failure to create test1.db again!\n");
      }

      printf("Closing test1.db again...\n");
      dba_close(mydb);
    } else {
      printf("Failure to create test1.db!\n");
    }

    dba_exit();
  } else {
    printf("Failed to initialize libdba: error = %d\n", error);
  }

  printf("Finished test1\n");

  return 0;
}
