/***********************************************************************
 *                libdba - A database agent library                    *
 *             Copyright (C) 2000,2001 Michael Brownlow                *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __DBA_POOL_H__
#define __DBA_POOL_H__ 1

#include "dba.h"

#undef __BEGIN_DECLS
#undef __END_DECLS
#ifdef __cplusplus
# define __BEGIN_DECLS extern "C" {
# define __END_DECLS }
#else
# define __BEGIN_DECLS /* empty */
# define __END_DECLS /* empty */
#endif
#undef __P
#if defined (__STDC__) || defined (_AIX) \
        || (defined (__mips) && defined (_SYSTYPE_SVR4)) \
        || defined(WIN32) || defined(__cplusplus)
# define __P(protos) protos
#else
# define __P(protos) ()
#endif

#undef PACKAGE
#define PACKAGE "libdba"

__BEGIN_DECLS

int __dba_init __P((int));
void __dba_exit __P((void));
int __dba_add_db __P((DBA *));
int __dba_remove_db __P((DBA *));
DBA *__dba_find __P((const char *));
char *__dba_db_string __P((int));
void __dba_print_error __P((const char *, ...));
void __dba_print_warning __P((const char *, ...));
void __dba_print_debug __P((const char *, ...));
void __dba_print_stderr __P((const char *, const char *, va_list *));
void __dba_print_string_info __P((const char *, const char []));

__END_DECLS

#endif /* __DBA_POOL_H__ */
