/***********************************************************************
 *                libdba - A database agent library                    *
 *             Copyright (C) 2000,2001 Michael Brownlow                *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#include "dba_list.h"

int __dba_l_add __P((DBA **start, DBA **end, DBA *dba))
{
  if((*start == NULL)&&(*end == NULL)) {
    *start = *end = dba;
    return 1;
  }

  (*end)->next = dba;
  dba->prev = *end;
  *end = dba;
  
  return 1;
}

int __dba_l_remove __P((DBA **start, DBA **end, DBA *dba))
{
  if((*start == NULL)&&(*end == NULL)) {
    return DBA_FAIL; /* no entries to remove */
  }

  if((*start == dba)&&(*end == dba)) {
    *start = *end = NULL;
    return DBA_SUCCEED;
  }

  if(*start == dba) {
    *start = dba->next;
    (*start)->prev = NULL;
    return DBA_SUCCEED;
  }

  if(*end == dba) {
    *end = dba->prev;
    (*end)->next = NULL;
    return DBA_SUCCEED;
  }

  dba->prev->next = dba->next;
  dba->next->prev = dba->prev;

  return DBA_SUCCEED;
}
