/***********************************************************************
 *                libdba - A database agent library                    *
 *             Copyright (C) 2000,2001 Michael Brownlow                *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __DBA_DB_H__
#define __DBA_DB_H__ 1

#include "dba.h"

__BEGIN_DECLS

#ifdef HAVE_TARGET_DB

#if HAVE_DB2_DB_H
# include <db2/db.h>
#else
# if HAVE_DB_H
#  include <db.h>
# endif
#endif

/* DB funcitons */
int __dba_db_init __P((void));
int __dba_db_open __P((DBA *));
int __dba_db_close __P((DBA *));
void __dba_db_memsetDBT __P((DBT *));
void __dba_db_freeDBT __P((DBT *));
DBT *__dba_db_setDBTChar __P((DBT *, const char *));
DBT *__dba_db_setDBTLong __P((DBT *, const long));
int __dba_db_add __P((DBA *, int, const char *, ...));
int __dba_db_set __P((DBA *, int, const char *, ...));
int __dba_db_del __P((DBA *, const char *));
void *__dba_db_get __P((DBA *, int, const char *, void *));
int __dba_db_exists __P((DBA *, const char *));
int __dba_db_register __P((DBA *));

#endif

__END_DECLS

#endif /* __DBA_DB_H__ */
