/***********************************************************************
 *                libdba - A database agent library                    *
 *             Copyright (C) 2000,2001 Michael Brownlow                *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#ifndef __DBA_H__
#define __DBA_H__ 1

#include <stdarg.h>
#include <string.h>

#undef __BEGIN_DECLS
#undef __END_DECLS
#ifdef __cplusplus
# define __BEGIN_DECLS extern "C" {
# define __END_DECLS }
#else
# define __BEGIN_DECLS /* empty */
# define __END_DECLS /* empty */
#endif

#ifndef __P
# ifdef __cplusplus
#  if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ > 7)
#   define __P(args)          args throw ()
#  else
#   define __P(args)          args
#  endif
# elif defined __STDC__ && __STDC__ > 0
#  define __P(args)           args
# else
#  define __P(args)           ()
# endif
#endif

#ifndef __PMT
# ifdef __cplusplus
#  define __PMT(args)         args
# elif defined __STDC__ && __STDC__ > 0
#  define __PMT(args)         args
# else
#  define __PMT(args)         ()
# endif
#endif

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

__BEGIN_DECLS

/* Database status */
#define DBA_READY        1
#define DBA_NOTREADY     0

/* Database types */
#define DBA_DB_UNKNOWN   0  /* Undefined database type */
#define DBA_DB_CSV       1  /* comma separated values  */
#define DBA_DB_DB        2  /* SleepyCat DB            */

/* Init return codes */
#define DBA_INIT_SUCCEED 0  /* libdba initialization succeded */
#define DBA_INIT_INIT   -1  /* libdba already initialized     */
#define DBA_INIT_FAIL    1  /* libdba initialization failed   */

/* Generic return codes */
#define DBA_SUCCEED      0
#define DBA_FAIL         1

/* Allowable data types */
#define DBA_DT_UNKNOWN   0
#define DBA_DT_LONG      1
#define DBA_DT_STRING    2

typedef struct __DBA {
  char *filename;
  int  db_type;
  void *db;
  int refs;
  int  (*open) __PMT((struct __DBA *));
  int  (*close) __PMT((struct __DBA *));
  int  (*add) __PMT((struct __DBA *, int, const char *, ...));
  int  (*set) __PMT((struct __DBA *, int, const char *, ...));
  int  (*del) __PMT((struct __DBA *, const char *));
  void *(*get) __PMT((struct __DBA *, int, const char *, void *));
  int  (*exists) __PMT((struct __DBA *, const char *));
  struct __DBA *next;
  struct __DBA *prev;
} DBA;

/* User interface */
int dba_init __P((int));
void dba_exit __P((void));
DBA *dba_open __P((DBA *, const char *, int));
void dba_close __P((DBA *));
int dba_add __P((DBA *, int, char *, ...));
int dba_set __P((DBA *, int, char *, ...));
int dba_del __P((DBA *, char *));
void *dba_get __P((DBA *, int, char *, void *));
int dba_exists __P((DBA *, const char *));

/* Generic functions, should not be called directly */
extern int __dba_init __P((int));
extern void __dba_exit __P((void));
extern void *__dba_realloc __P((void*, size_t));
extern void *__dba_malloc __P((size_t));
extern void *__dba_free __P((void *));
extern int __dba_add_db __P((DBA *));
extern DBA *__dba_find __P((const char *));
extern void __dba_print_error __P((const char *, ...));
extern void __dba_print_warning __P((const char *, ...));
extern void __dba_print_debug __P((const char *, ...));
extern void __dba_print_stderr __P((const char *, const char *, va_list *));
extern void __dba_print_string_info __P((const char *, const char []));

__END_DECLS

#endif /* __DBA_H__ */
