/***********************************************************************
 *            iwsmake - Wsmake configuration file editor               *
 *               Copyright (C) 2001 Michael Brownlow                   *
 *                                                                     *
 * This program is free software; you can redistribute it and/or modify*
 * it under the terms of the GNU General Public License as published by*
 * the Free Software Foundation; either version 2 of the License, or   *
 * (at your option) any later version.                                 *
 *                                                                     *
 * This program is distributed in the hope that it will be useful,     *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of      *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the       *
 * GNU General Public License for more details.                        *
 *                                                                     *
 * You should have received a copy of the GNU General Public License   *
 * along with this program; if not, write to the Free Software         *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.           *
 *                                                                     *
 * For questions and comments, please email the author at:             *
 * mike@wsmake.org                                                     *
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <tui/tui.h>

#include "iwsmake.h"

void iwsmakeEnd(int);
void splashRefresh(tuiWindow);
int  helpAbout(void);
int  fileExit(void);

int done;

int main(int argc, char **argv)
{
  int key = (int)'\0';
  tuiMenuBar mb = NULL;
  tuiMenu mb_file = NULL;
  tuiMenu mb_help = NULL;
  tuiMenuItem mb_file_new = NULL;
  tuiMenuItem mb_file_open = NULL;
  tuiMenuItem mb_file_close = NULL;
  tuiMenuItem mb_file_exit = NULL;
  tuiMenuItem mb_help_about = NULL;
  tuiWindow w_splash = NULL;

  tuiInitMore(iwsmakeEnd);

  mb = tuiMenuBarNew(TUIMENUBAR_TOP, COLOR_PAIR(1));
  mb_file = tuiMenuNew(mb, "_File", TUIMENU_LEFT,
		       COLOR_PAIR(1),        COLOR_PAIR(2),
		       COLOR_PAIR(3)|A_BOLD, COLOR_PAIR(2));
  mb_help = tuiMenuNew(mb, "_Help", TUIMENU_RIGHT,
		       COLOR_PAIR(1),        COLOR_PAIR(2),
		       COLOR_PAIR(3)|A_BOLD, COLOR_PAIR(2));

  mb_file_new = tuiMenuItemNew(mb_file, "_New...", TUIMENUITEM_CB, NULL);
  tuiMenuAppendSeparator(mb_file, NULL);
  mb_file_open = tuiMenuItemNew(mb_file, "_Open...", TUIMENUITEM_CB, NULL);
  mb_file_close = tuiMenuItemNew(mb_file, "_Close", TUIMENUITEM_CB, NULL);
  tuiMenuAppendSeparator(mb_file, NULL);
  mb_file_exit = tuiMenuItemNew(mb_file, "E_xit", TUIMENUITEM_CB, fileExit);
  mb_file_close->enabled = 0;
  mb_help_about = tuiMenuItemNew(mb_help, "_About", TUIMENUITEM_CB, helpAbout);

  w_splash = tuiWinNew(w_splash, 0, 1, 0, 0, 0, 0, 0, 0, splashRefresh, NULL);

  done = 0;

  while(!done) {
    tuiRefresh();
    doupdate();
    key = getch();
    switch(key) {
    case 0x01:
      tuiMenuActivate(mb_file);
      break;
    }
  }
  tuiRefresh();
  doupdate();

  w_splash = tuiWinDelete(w_splash);

  mb_file_new = tuiMenuItemDelete(mb_file_new);
  mb_file_open = tuiMenuItemDelete(mb_file_open);
  mb_file_close = tuiMenuItemDelete(mb_file_close);
  mb_file_exit = tuiMenuItemDelete(mb_file_exit);
  mb_help_about = tuiMenuItemDelete(mb_help_about);

  mb_help = tuiMenuDelete(mb_help);
  mb_file = tuiMenuDelete(mb_file);
  mb = tuiMenuBarDelete(mb);

  tuiExitMore(0);

  return 0;
}

void splashRefresh(tuiWindow win)
{
  mvwprintw(win->win, 2, win->tw/2-7, "Iwsmake v%s", IWSMAKEVERSION);
  mvwprintw(win->win, 4, win->tw/2-17, "Copyright (c) 2001 Michael Brownlow");
  mvwprintw(win->win, 7, win->tw/2-18, "Press Ctrl-A to activate the menubar.");
}

void iwsmakeEnd(int error)
{
  if(error != 0) {
    fprintf(stderr, "iwsmake error: (%d) %s\n", error, strerror(error));
    exit(EXIT_FAILURE);
  } else {
    exit(EXIT_SUCCESS);
  }
}

int helpAbout(void)
{
  tuiDialog d;
  d = tuiDialogNew("About Iwsmake", TUIDIALOG_OK,
		   "Iwsmake is Copyright (c) 2001 by Michael Brownlow\n\n"
		   "Iwsmake is a text-based configuration interface for\n"
		   "wsmake configuration files. It is very early in the\n"
		   "development phase at this time. So early in fact that\n"
		   "the only functional part is this \"About\" dialog. :)");

  tuiDialogActivate(d);

  d = tuiDialogDelete(d);

  return 0;
}

int fileExit(void)
{
  done = 1;

  return 0;
}
