AC_DEFUN([IWSMAKE_CHECKS],[

AC_SUBST(IWSMAKELIBS)
AC_SUBST(IWSMAKEINCDIR)

AC_DEFINE(IWSMAKEVERSION, "0.0.1", [Iwsmake version number])

AC_ARG_WITH(iwsmake,
[  --with-iwsmake          compile the iwsmake package. [default=no]], [
  if test "$with_iwsmake" = yes; then
    use_iwsmake="yes"
    AM_CONDITIONAL(IWSMAKE, true)
  else
    use_iwsmake="no"
    AM_CONDITIONAL(IWSMAKE, false)
  fi
],[
  use_iwsmake="no"
  AM_CONDITIONAL(IWSMAKE, false)
])

AC_ARG_WITH(tui-libdir,
[  --with-tui-libdir       if you have installed libtui in a special area,
                          enter the library directory it is in with this
                          flag. (or use the LD_LIBRARY_PATH env variable)], [
  LIBS="$LIBS -L$with_tui_libdir"
],)
AC_ARG_WITH(tui-incdir,
[  --with-tui-incdir       if you have installed libtui in a special area,
                          enter the include directory it is in with this
                          flag. (or use the CFLAGS env variable)], [
  CFLAGS="$CFLAGS -I$with_tui_incdir"
],)

if test "$use_iwsmake" = yes; then
  dnl Check for some libraries that iwsmake will need
  AC_CHECK_LIB(ncurses, initscr,[
    IWSMAKELIBS="-lncurses"
  ],[
    AC_CHECK_LIB(curses, initscr,[
      IWSMAKELIBS="-lcurses"
    ],[
      AC_MSG_ERROR([

A curses library is needed for compiling iwsmake. You can get one
at: ftp://ftp.gnu.org/pub/gnu/ncurses])
])
])

  AC_CHECK_LIB(tui, tuiExit,[
    IWSMAKELIBS="$IWSMAKELIBS -ltui"
  ],[
    AC_MSG_ERROR([

The libtui library is needed for compiling iwsmake. You can get it
at: http://www.wsmake.org/~mike/software/libtui/])
], "-lcurses")
fi
])