AC_DEFUN([GETOPT_CHECKS],[

AC_SUBST(GETOPTLDADD)
AC_SUBST(GETOPTINCLUDE)

AC_ARG_ENABLE(getopt-long,
[  --enable-getopt-long    enable to use the getopt_long that comes with wsmake;
                          disable to use only getopt; don\'t specify at all
                          to autodetect a system getopt_long with getopt as
                          a fallback [default=no,autodetect]], [
 if test "$enable_getopt_long" = yes; then
  AC_DEFINE(HAVE_GETOPT_LONG,1,[Define if you have getopt_long])
  AC_DEFINE(LOCAL_GETOPT,1,[Define if you want to use the local getopt])
  AM_CONDITIONAL(GETOPT, true)
  GETOPTLDADD="\$(top_srcdir)/getopt/libgetopt.a"
  GETOPTINCLUDE="-I\$(top_srcdir)/getopt"
  CFLAGS="-fno-strict-prototypes $CFLAGS"
 else
  AM_CONDITIONAL(GETOPT, false)
  GETOPTLDADD=""
  GETOPTINCLUDE=""
  AC_DEFINE(HAVE_GETOPT_LONG,0,[Define if you have getopt_long])
  AC_DEFINE(LOCAL_GETOPT,0,[Define to use the local getopt])
 fi
],[
 AM_CONDITIONAL(GETOPT, false)
 GETOPTLDADD=""
 GETOPTINCLUDE=""
 AC_CHECK_FUNC(getopt_long, [
  AC_DEFINE(HAVE_GETOPT_LONG,1,[Define if you have getopt_long])
  AC_DEFINE(LOCAL_GETOPT,0,[Define to use the local getopt])
 ],[
  AC_DEFINE(HAVE_GETOPT_LONG,0,[Define if you have getopt_long])
  AC_DEFINE(LOCAL_GETOPT,0,[Define to use the local getopt])
 ])
])
])

