AC_DEFUN([DB_CHECKS],[

have_db_target="no"
have_csv_target="no"

# CSV - Comma Separated Values
AC_ARG_WITH(csv,
[  --with-csv              define this if you want comma separated values (CSV)
                          to be available as a database type. [default=yes]], [
  if test "$with_csv" = yes; then
    have_csv_target="yes"
    AC_DEFINE(HAVE_TARGET_CSV,1, [Define if you want csv target])
  fi
],[
  have_csv_target="yes"
  AC_DEFINE(HAVE_TARGET_CSV,1, [Define if you want csv target])
])

# DB - Berkeley DB
AC_ARG_WITH(berkeley-db,
[  --with-berkeley-db      define this if you want to use Berkeley DB. If this
                          is defined, configure will try to autodetect your DB.
                          [default=no]], [
  if test "$with_berkeley_db" = yes; then
    AC_CHECK_LIB(db, db_create, [
      have_db_target="yes"
      AC_CHECK_HEADERS(db.h,break,have_db_target="no")
      LIBS="-ldb $LIBS"
      AC_DEFINE(HAVE_TARGET_DB,1, [Define if you want DB target])
    ], [
      AC_MSG_ERROR([couldn\'t find a Berkeley DB library. Quitting.])
    ])
  fi
],)

# Issue warnings if no database targets found
if test "$have_db_target" = no && test "$have_csv_target" = no; then
  AC_MSG_ERROR([no database targets were detected. Quitting.])
fi

])
