#include "includes.h"

void game::initialize()
{
	allegro_init();

	install_keyboard();

	set_gfx_mode(GFX_AUTODETECT_WINDOWED, SCREEN_WIDTH, SCREEN_HEIGHT, 0, 0);

	graphics::initialize(SCREEN_WIDTH, SCREEN_HEIGHT, screen);
	graphics *instance = graphics::get_instance();
			
	int player_y = (instance->h / 2) - (PLAYER_HEIGHT / 2);

	p1 = new player(0, player_y, KEY_Q, KEY_A, PLAYER_Y_SPEED, PLAYER_IMAGE_FILE);
	p2 = new player(instance->w - PLAYER_WIDTH, player_y, KEY_P, KEY_L, PLAYER_Y_SPEED, PLAYER_IMAGE_FILE);
			
	b = new ball(instance->w / 2 - BALL_WIDTH / 2, instance->h / 2 - BALL_HEIGHT / 2, BALL_X_SPEED, BALL_Y_SPEED, BALL_IMAGE_FILE, p1, p2);
}
		
void game::draw()
{
	score::draw();
	p1->draw();
	p2->draw();
	b->draw();
			
	graphics::get_instance()->swap_buffers();
}
		
void game::loop()
{
	while (!key[KEY_ESC])
	{
		acquire_screen();
				
		p1->move();
		p2->move();

		if (b->move())
		{
			allegro_exit();
			return;
		}
				
		draw();
				
		release_screen();

		usleep(USECONDS);
	}

	exit(0);
}
