#include "includes.h"

bool ball::collides(player *p)
{
	if ((x <= p->x + p->w && x + w > p->x + p->w) || (x + w >= p->x && x < p->x + p->w))
		if ((y <= p->y + p->h && y + h > p->y + p->h) || (y + h >= p->y && y < p->y + p->h))
			return true;

	return false;
}

ball::ball(int x, int y, int x_speed, int y_speed, char *image_file, player *p1, player *p2):
	entity(x, y, x_speed, y_speed, image_file),
	p1(p1),
	p2(p2)
{ }
		
bool ball::move()
{
	if (collides(p1) || collides(p2))
		x_speed *= -1;

	graphics *instance = graphics::get_instance();

	if (x < 0 || x + w > instance->w)
		return true;
	if (y < 0 || y + h > instance->h)
		y_speed *= -1;
			
	x += x_speed;
	y += y_speed;

	return false;
}
