/*

jdtracker - Collects access statistics from remote sites

Copyright (c) 1999 John Douglas Rowell
 
This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version. 

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#define APPNAME   "jdtracker"
#define FILENAME  "jdtracker.c"
#define LOGFILE   "jdtracker.log"

#define MAXENTRYLEN    2048
#define REFERRERFIELD  "ref="
#define TIMELEN        30
#define TIMEFORMAT     "%d/%b/%Y:%T %z"
#define LOGFORMAT      "%s - - [%s] \"%s %s HTTP/1.0\" 200 0 \"%s\" \"%s\"\n"

void jd_die(const char* msg, const char* appname, const char* filename) {
	char fullmsg[strlen(msg) + strlen(appname) + strlen(filename) + 3];

        strcpy(fullmsg, appname);
        strcat(fullmsg, ":");
        strcat(fullmsg, filename);
        strcat(fullmsg, ":");
        strcat(fullmsg, msg);

        perror(fullmsg); 
	exit(1);
}

struct flock* file_lock(short type, short whence) {
	static struct flock ret ;

	ret.l_type = type;
	ret.l_start = 0;
	ret.l_whence = whence;
	ret.l_len = 0;
	ret.l_pid = getpid();

	return &ret;
}

int append_lock(int fd) {
	return fcntl(fd, F_SETLKW, file_lock(F_WRLCK, SEEK_END));
}

int unlock(int fd) {
	return fcntl(fd, F_SETLKW, file_lock(F_UNLCK, SEEK_END));
}

void sendgif() {
	/* A 1x1 transparent GIF (made with The Gimp :P) */
	char* strGIF = "\x47\x49\x46\x38\x39\x61\x01\x00\x01\x00\x80"
		"\x00\x00\xFF\xFF\xFF\xFF\xFF\xFF\x21\xF9\x04"
		"\x01\x0A\x00\x01\x00\x2C\x00\x00\x00\x00\x01"
		"\x00\x01\x00\x00\x02\x02\x4C\x01\x00\x3B";

	/* Prevent caching */
	printf("Pragma: no-cache\n");
	printf("Expires: Friday, August 6, 1999 15:46:44 GMT\n");
	printf("Content-Type: image/gif\n\n");
	fwrite(strGIF, 43, 1, stdout);
}

void logit(const char *strLog) {
	int fLog;
	char strTime[TIMELEN + 1];
	char strEntry[MAXENTRYLEN + 1];
	char *strUnknown = "-";
	char *strRoot = "/";
	char* strURL;
	char* strReferrer;
	time_t theTime;
	int i;

	/* Format the URL (strip 'http://my.server.com/') */

	strURL = getenv("HTTP_REFERER");
	if (!strURL || strstr(strURL, "http://") != strURL) {
		/* malformed referrer - IGNONE */
		/* was: strURL = strUnknown; */
		return;
	} else {
		for (i = 0; i < 3; i++) {
			if (strURL) { strURL = strchr(++strURL, '/'); }
		}
		if (!strURL) { strURL = strRoot; }
	}

	/* Get the referrer from QUERY_STRING */

	strReferrer = getenv("QUERY_STRING");
	if (!strReferrer) {
		strReferrer = strUnknown;
	} else {
		strReferrer = strstr(strReferrer, REFERRERFIELD);
		if (!strReferrer) {
			strReferrer = strUnknown;
		} else {
			strReferrer += strlen(REFERRERFIELD);
		}
	}
	if (strlen(strReferrer) == 0) { strReferrer = strUnknown; }

	/* Format the time just like Apache logs do */
	time(&theTime);
	strftime(strTime, TIMELEN, TIMEFORMAT, localtime(&theTime));

	/* Open for append, write only, mode 664 - create it if not there */
	fLog = open(strLog, O_WRONLY | O_CREAT | O_APPEND, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH);
	if (fLog == -1) { jd_die("can't open log file", APPNAME, FILENAME); }

	/* Lock file and print */
	if (append_lock(fLog) == -1) { jd_die("can't lock log file", APPNAME, FILENAME); } 

	if (snprintf(strEntry, sizeof(strEntry),
		LOGFORMAT,
		getenv("REMOTE_ADDR"),
		strTime,
		getenv("REQUEST_METHOD"),
		strURL,
		strReferrer,
		getenv("HTTP_USER_AGENT") ) == -1) {
		jd_die("log entry too long (>2048 bytes). overflow attempt?", APPNAME, FILENAME);
	}
	if (write(fLog, strEntry, strlen(strEntry)) == -1) { jd_die("couldn't write to log file", APPNAME, FILENAME); }

	/* Flush output, unlock file and close it */
	if (fsync(fLog) == -1) { jd_die("coudn't flush log file", APPNAME, FILENAME); }
	if (unlock(fLog) == -1) { jd_die("can't unlock log file", APPNAME, FILENAME); } 
	if (close(fLog) == -1) { jd_die("can't close log file", APPNAME, FILENAME); }
}

int main(int argc, char *argv[]) {
	sendgif();
	logit(LOGFILE); 

	exit(0);
}

