#include <pwd.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdarg.h>
#include <icq.h>
#include <errno.h>
#include <sys/stat.h>



#define LOGIN_DELAY			5	// how long should i wait for login	
#define RESPONSE_DELAY      5	// what is the response time of icq
#define KEEP_ALIVE_DELAY	120	// send keep alive every KEEP_ALIVE_DELAY
#define MAX_MSG_LENGTH		450	// what is the longest message?
#define MAX_MESSAGES		500	// what is the longest message?

static int login_ok = 0;		// signals 

char* messages[MAX_MESSAGES];
long uins[MAX_MESSAGES];
char passwd[10];
char *msgfile;

int	 count		= -1;
char *url		= 0;
int  urlsend	= 0;
long uin		= 0;
char *icqhost	= "icq.mirabilis.com";
int icqport		= 4000;
int quiet		= 0;

// debugging function for internal use
int Info(char *fmt, ...) 
{
  	char 	err_buf[512]; 
  	int 	i;
  	va_list args;

	if (quiet)
		return 0;
  
	va_start(args, fmt);
  	
	i = vsprintf(err_buf, fmt, args);
  
	va_end(args);

  	fprintf(stdout, "%s\n", err_buf);
  
  	return i;
}

// debugging function for internal use
int Error(char *fmt, ...) 
{
  	char 	err_buf[512]; 
  	int 	i;
  	va_list args;

	if (quiet)
		return 0;
  
	va_start(args, fmt);
  	
	i = vsprintf(err_buf, fmt, args);
  
	va_end(args);

  	fprintf(stderr, "icqsend: %s\n", err_buf);
  
  	return i;
}

// get responses until no more available
int getResponses()
{
	fd_set rfds;
	int    sok=icq_GetSok();
	struct timeval tv;

	Info("getResponses");
	// end after timeout
	while(1)
	{
		FD_ZERO(&rfds);
		FD_SET(sok, &rfds);

		tv.tv_sec  = RESPONSE_DELAY;
		tv.tv_usec = 0;

		// if timeout assume nothing else coming
		if(select(sok+1, &rfds, NULL, NULL, &tv)==0)
		{
			Info ("No more responses from server");
			return 1;
		}
			
		// if socket readable handle it
		if(FD_ISSET(sok, &rfds))
		{
			icq_HandleServerResponse();
		}
	}

	// never reached !!!
	return 0;
}


// wait for login and than send message
int wait_for_login()
{
	fd_set rfds;
	int    sok=icq_GetSok();
	struct timeval tv;

	int time_to_ping          = KEEP_ALIVE_DELAY ;
	int time_to_login_timeout = LOGIN_DELAY      ;

	time_t start;
	time_t end  ;

	// wait for login
	while(!login_ok)
	{
		icq_HandleServerResponse();

		FD_ZERO(&rfds);
		FD_SET(sok, &rfds);
		tv.tv_sec  = time_to_ping;

		if(!login_ok && tv.tv_sec>time_to_login_timeout)
			tv.tv_sec  = time_to_login_timeout;

		tv.tv_usec = 0;

		start  = time(NULL);
		end    = time(NULL);

		if(!login_ok)
		{
			time_to_login_timeout-=(end-start);

			if(time_to_login_timeout<=0)
			{
				Error("Login timeout. Exiting.");
				return 1;
			}
		}
	}
}

// read_messages
int load_messages(char *file)
{
	FILE *input;
	char *msg;
	char *msgout;
	char *pmsgout;
	char *dollar;
	
	msg = (char*)malloc(MAX_MSG_LENGTH);
	msgout = (char*)malloc(MAX_MSG_LENGTH);

	if (!msg && !msgout)
	{
		Error("out of memory... you lack ram, buy more");
		exit(0);
	}
	
	memset (uins, 0, MAX_MESSAGES*sizeof(int));
	
	if (!strcmp(file, "-"))
	{
		input = stdin;
	}
	else
	{
		if ((input = fopen (file, "r")) == NULL)
		{
			Error ("Cannot open file %s [%d:%s]\n", file, errno, strerror(errno));
			exit (-1);
		}
	}

	while (1)
	{
		// get uin
		memset (msg, 0, MAX_MSG_LENGTH);
		if ( fgets(msg, 12, input) == NULL )
		{
			Info("No more messages found");
			return -1;
		}
		uins[count + 1] = atol(msg);

		Info("--> got uin %d", uins[count+1]);

		// get message
		memset (msg, 0, MAX_MSG_LENGTH);
		if ( fgets(msg, MAX_MSG_LENGTH, input) == NULL )
		{
			Info("No more messages found");
			return 1;
		}

		if (strlen(msg) > 0)   msg[strlen(msg) - 1] = 0;	
		Info("    got message %s", msg);

		memset (msgout, 0, MAX_MSG_LENGTH);
		dollar  = msg;
		pmsgout = msgout;

		while (*dollar)
		{
			if (*dollar == 36)
			{
				*pmsgout = 13;
				pmsgout++;
				*pmsgout = 10;
			}
			else
			{
				*pmsgout =  *dollar;
			}

			pmsgout++;
			dollar++; 
		}

		messages[count+1] = (char*)strdup(msgout);

		count++;
	}
	
	return 0;
}

// send messages
int send_messages()
{
	int i = 0;

	while(i <= count)
	{
		if (urlsend == 0)
		{
			Info ("Sending plain message to: %d", uins[i]);
			icq_SendMessage(uins[i], messages[i]);
		}
		else
		{
			Info ("Sending url message to: %d", uins[i]);
			icq_SendURL(uins[i], url, messages[i]);
		}

		getResponses();
		i++;
	}

	return 0;
}


// if lost close program
void connectionLost()
{
	Error("Connection to server lost. Exiting.");
	exit(-1);
}

// logged in - yeah
void logged()
{
	login_ok=1;

	Info("logged in");
}

// logs infos
void doLog(time_t time, unsigned char level, const char *str)
{
	Info("%d %s",(int) level, str);
}

// authorization request send?
void RespondAuthReq (unsigned long uin,
					unsigned char hour,
					unsigned char minute,
					unsigned char day,
					unsigned char month,
					unsigned short year,
					const char *nick,
					const char *first,
					const char *last,
					const char *email,
					const char *reason)
{
	Info("Authorization request received from %ld. Reason: %s\n", uin, reason);
	icq_SendAuthMsg(uin);
}

//usage
void usage(char* msg)
{
	Info("icqsend 0.06pre - written by Gottfried Szing <e9625460@stud3.tuwien.ac.at>");
	Info("        icqsend is available at http://yasd.dhs.org/\n");

	if (msg != NULL) Info("Info: %s\n", msg);

	Info("usage: icqsend [-h] [-n] [-l d] [-i<uin>] [-p<password>] [-u <url>] [-f <msgfile> | - ]\n");
	Info("  -h            prints this help page");
	Info("  -f msgfile    file containing messages or stdin");
	Info("  -i uin        icq login number");
	Info("  -p password   password for login");
	Info("  -u url        optional global url to be transmitted");
	Info("  -n            turns url sending off. Only useful to override icqsendrc!");
	Info("  -q            be quiet and dont produce any output");
	Info("  -l d          define the log level of icq lib ( 0 <= d <= 4) - 0 means off\n");
	Info("All options override default settings stored in ~/.icqsendrc");

	exit (-1);
}

void parsecommandline(int argc, char** argv)
{
	int c;

	// get commandline options
	opterr=1;
	while ( (c=getopt(argc,argv,"hl:qi:u:p:f:n")) != -1)
	{
		switch (c)
		{
		case 'q':   quiet = 1;
					break;
		case 'n':   urlsend = 0;
					break;
		case 'u':   urlsend = 1;
					url = (char*)strdup(optarg);
					break;
		case 'f':   msgfile = (char*)strdup(optarg);
					break;
		case 'i':   uin = atol(optarg);
					break;
		case 'l':   icq_LogLevel = atol(optarg);
					break;
		case 'p':   strcpy(passwd, optarg);
					break;
		case 'h':   usage(NULL);
					break;
		default:    usage("Wrong parameters");
		}
	}
}

void readconfigfile(int argc, char** argv)
{
	char configfile[2000];
	FILE *conffile;
	char *pfx = getenv("HOME");
	struct stat buf;

	if (!pfx)
	{
		struct passwd *pw = (struct passwd*)getpwuid(getuid());
			
		if (pw)
			pfx = pw->pw_dir;
	}

	strcat (configfile, pfx);	
	strcat (configfile, "/.icqsendrc");	
	
	conffile = fopen(configfile, "r");


	if (conffile == NULL)
	{
		Error("No config file %s", configfile);
		Error("Try to find UID/password at command line");

		parsecommandline(argc, argv);
	}
	else
	{
		char *line;
		char *name;
		char *value;
		mode_t modes;

		// check file permissions
		if (!stat(configfile, &buf))
		{
			if ( buf.st_uid != getuid())
			{
				usage("The file %s is not owned by you - sorry.");
			}

			modes = buf.st_mode;

			if ( (modes & ~(0700 | S_IFREG) ) )
			{
				usage("The config file must have the access rights 700.");
			}
		}
		else
		{
			Error ("Cannot determine owner and access right via stat.");
			Error ("Please check file options manually.");
		}

		Info("Loading config from %s", configfile);

		line = malloc(2000);

		if (line == NULL)
		{
			usage("Not enough memory available");
		}

		while (fscanf(conffile, "%s", line) && strcmp(line, ""))
		{
			name	= (char*)strsep(&line, "=");
			value	= (char*)strdup(line);

			if (!strcasecmp(name, "uid"))
				uin = atol(value);

			if (!strcasecmp(name, "password"))
				strcpy(passwd, value);

			if (!strcasecmp(name, "url"))
			{
				url = (char*)strdup(value);
				urlsend = 1;
			}

			if (!strcasecmp(name, "messages"))
				msgfile = (char*)strdup(value);

			if (!strcasecmp(name, "icqhost"))
				icqhost = (char*)strdup(value);

			if (!strcasecmp(name, "icqport"))
				icqport = atol(value);

			line = malloc(2000);
		}

		fclose (conffile);
	}


	// and now override default with command line
	parsecommandline(argc, argv);
	
	if (uin <= 0)
	{
		usage("no UIN supplied via the -i parameter");
	}

	if (!strcmp(passwd, ""))
	{
		usage("no password supplied");
	}

	if (!strcmp(msgfile, ""))
	{
		usage("no message file supplied");
	}
}


int main(int argc, char** argv)
{
	icq_LogLevel		= ICQ_LOG_WARNING;
	icq_Logged			= logged;
	icq_Log				= doLog;
	icq_Disconnected	= connectionLost;
	icq_RecvAuthReq		= RespondAuthReq;

	readconfigfile(argc, argv);

	Info("icqsend 0.06pre - written by Gottfried Szing <e9625460@stud3.tuwien.ac.at>\n");
	Info("        icqsend is available at http://yasd.dhs.org/\n");

	// load all messages from file
	load_messages(msgfile);

	icq_Init(uin, passwd);

	//icq_SetProxy("192.168.10.1", 1080, 0, "", "");

	if (icq_Connect(icqhost, icqport) != -1)
	{
		Info("connection ok");
	}
	else
	{
		Error("connection failed");
		exit(-1);
	}

	// go online
	Info("go online");
	icq_Login(STATUS_ONLINE);

	Info("wait for login");
	wait_for_login();

	Info("send messages");
	send_messages();

	getResponses();

	// and ciao
	Info("Logging out");
	icq_Logout();
	icq_Disconnect();

	return 0;
}
