#ifndef __tokenmaph__
#define __tokenmaph__

#ifndef __hitopcoreh__
  #include "hitopcore.h"
#endif

#include <map>
#include <string>
#include <algorithm>

class TokenMap{
public:
  typedef int Token;
private:
  static map<string,Token> m_tokenMap;
  static Token m_nextToken;
public:
  enum BuiltIns {DEF1,DEF2,SLASHDEF1,SLASHDEF2,IF1,IF2,ELSE1,ELSE2,SLASHIF1,
    SLASHIF2,ELSEIF,COMMENT,SLASHCOMMENT,FOR,
    A,ABBR,ACRONYM,ADDRESS,APPLET,B,BDO,BIG,BLOCKQUOTE,BODY,SLASHBODY,BR,
    BUTTON,CAPTION,CENTER,SLASHCENTER,CITE,CODE,COLGROUP,DD,SLASHDD,DEL,DFN,
    DIR,DIV,SLASHDIV,DL,SLASHDL,DT,SLASHDT,EM,FIELDSET,FONT,FORM,FRAMESET,H1,
    SLASHH1,H2,SLASHH2,H3,SLASHH3,H4,SLASHH4,H5,SLASHH5,H6,SLASHH6,HEAD,
    SLASHHEAD,HR,HTML,SLASHHTML,I,IFRAME,INS,KBD,LABEL,LEGEND,LI,SLASHLI,LINK,
    MAP,MENU,SLASHMENU,NOFRAMES,NOSCRIPT,OBJECT,OL,SLASHOL,OPTGROUP,OPTION,P,
    SLASHP,PRE,Q,S,SAMP,SCRIPT,SELECT,SMALL,SPAN,STRIKE,STRONG,STYLE,SUB,SUP,
    TABLE,SLASHTABLE,TBODY,TD,SLASHTD,TEXTAREA,TFOOT,TH,THEAD,TITLE,
    SLASHTITLE,TR,SLASHTR,TT,U,UL,SLASHUL,VAR,PLINGDOCTYPE};
  static void Init();
  static Token NameToTokenNum(string& name){
    if(!g_isXML) transform(name.begin(),name.end(),name.begin(),toupper);
    map<string,Token>::iterator pos=m_tokenMap.find(name);
    if(pos!=m_tokenMap.end()) return pos->second;
    m_tokenMap[name]=m_nextToken;
    return m_nextToken++;
  }
private:
  static void Insert(const string& a,Token b);
};

#endif
