#ifndef __stringproch__
#define __stringproch__

#include <string>
#include <vector>
#include <map>

#define __HITOPFUNC__ const HTML& cur,hitopValue& data,const vector<hitopValue>& params

class HTML;
class PolyType;

typedef PolyType hitopValue;

class StringProc {
public:
  static void ProcessString(const HTML& Cur,string& data,const string& inst);
  typedef void (*actionFunction)(__HITOPFUNC__);
  static void RegisterFunction(const string& name,actionFunction procedure);
  static void UnregisterFunction(const string& name,actionFunction procedure);
private:
  static void SetFunction(const string& name,actionFunction procedure);
  static map<string,actionFunction> actionMap;
  static bool actionMapInitialized;
  static void RANDOM(__HITOPFUNC__);
  static void REPEAT(__HITOPFUNC__);
  static void LENGTH(__HITOPFUNC__);
  static void FREQ(__HITOPFUNC__);
  static void REPLACE(__HITOPFUNC__);
  static void UPCASE(__HITOPFUNC__);
  static void DOWNCASE(__HITOPFUNC__);
  static void REMOVENOTOF(__HITOPFUNC__);
  static void ESCAPEURL(__HITOPFUNC__);
  static void UNESCAPEURL(__HITOPFUNC__);
  static void ESCAPECHARS(__HITOPFUNC__);
  static void UNESCAPECHARS(__HITOPFUNC__);
  static void EVAL(__HITOPFUNC__);
  static void MID(__HITOPFUNC__);
  static void LEFT(__HITOPFUNC__);
  static void RIGHT(__HITOPFUNC__);
  static void PADLEFT(__HITOPFUNC__);
  static void PADRIGHT(__HITOPFUNC__);
  static void BEFORE(__HITOPFUNC__);
  static void AFTER(__HITOPFUNC__);
  static void REVERSE(__HITOPFUNC__);
  static void WORDS(__HITOPFUNC__);
  static void WORDSPAN(__HITOPFUNC__);
  static void WORD(__HITOPFUNC__);
  static void DATETODAYNUM(__HITOPFUNC__);
  static void DAYNUMTODATE(__HITOPFUNC__);
  static void DAYOFWEEK(__HITOPFUNC__);
  static void C2X(__HITOPFUNC__);
  static void D2X(__HITOPFUNC__);
  static void ROMAN(__HITOPFUNC__);
  static void FORMATINT(__HITOPFUNC__);
  static void FORMATFLOAT(__HITOPFUNC__);
  static void InitializeActionMap();
  class notin;
};

#endif
