#ifndef __pluginh__
  #include "../plugin.h"
#endif
#ifndef __htmlh__
  #include "../html.h"
#endif
#ifndef __parammaph__
  #include "../parammap.h"
#endif
#ifndef __hitopcommandsh__
  #include "../hitopcommands.h"
#endif
#ifndef __errorh__
  #include "../error.h"
#endif
#ifndef __polytypeh__
  #include "../polytype.h"
#endif
#ifndef __tables_entitiesh__
  #include "../tables/entities.h"
#endif

#include <string>
#include <mysql/mysql.h>
#include <vector>
#include <algorithm>

class dsoDBmysqlMod :public Plugin{
public:
  dsoDBmysqlMod();
  virtual void Init();
private:
  static void ESCAPE(__HITOPFUNC__);
};

class DBmysql :public DBaseBase {
private:
  MYSQL* m_connection;
public:
  virtual void Disconnect(HTMLStream &stream,HTMLStream::iterator cur,
      const ParamMap& params);
  virtual void Query(HTMLStream &stream,HTMLStream::iterator cur,
      const string& entryproc,const ParamMap& params,bool is_discard, bool is_assign);
  static DBaseBase* Connect(const string& handle,HTMLStream &stream,
      HTMLStream::iterator cur,const ParamMap& paramMap); 
};

static dsoDBmysqlMod initmodule;

dsoDBmysqlMod::dsoDBmysqlMod() {
  RegisterPlugin(string("mysql"),2);
}

void dsoDBmysqlMod::Init(){
  RegisterDBDriver(string("MYSQL"),&DBmysql::Connect);
  SetNamespace("MYSQL");
  RegisterFunction("ESCAPE",&dsoDBmysqlMod::ESCAPE);
}

DBaseBase* DBmysql::Connect(const string& handle, HTMLStream &stream,
    HTMLStream::iterator cur, const ParamMap& paramMap) {
  DBmysql *result = new DBmysql;
  result->m_connection=new MYSQL;
  mysql_init(result->m_connection);
  string server="localhost";
  paramMap.Retrieve("SERVER",server);
  server=Entities::Unescape(server);
  string port_s;
  unsigned int port=0;
  if (paramMap.Retrieve("PORT",port_s)) {
    port_s=Entities::Unescape(port_s);
    port=atoi(port_s.c_str());
  }
  string user;
  paramMap.Retrieve("USER",user);
  user=Entities::Unescape(user);
  string password;
  paramMap.Retrieve("PASSWORD",password);
  password=Entities::Unescape(password);
  string socket;
  paramMap.Retrieve("SOCKET",socket);
  socket=Entities::Unescape(socket);
  string db;
  paramMap.Retrieve("DATABASE",db);
  db=Entities::Unescape(db);
  if (NULL==mysql_real_connect(result->m_connection,server.c_str(),user.c_str(),
      password.c_str(),db.c_str(),port,(socket.empty()?NULL:socket.c_str()),0)) {
    Error(*cur,string(mysql_error(result->m_connection)));
  }
  return result;
}
void DBmysql::Query(HTMLStream &stream,HTMLStream::iterator cur,
    const string& entryproc,const ParamMap& params, bool is_discard, bool is_assign) {
  string query;
  if (!params.Retrieve("SQLQUERY",query)) {
    Error(*cur,"Missing SQLQUERY parameter");
  }
  query=Entities::Unescape(query);
  if (0!=mysql_query(m_connection,query.c_str())) {
    Error(*cur,string(mysql_error(m_connection)));
  }
  if (!is_discard) {
    MYSQL_RES *result = mysql_store_result(m_connection);
    MYSQL_ROW row;
    if (result!=NULL) {
      //effective NOOP if there are no results
      int numfields=mysql_num_fields(result);
      MYSQL_FIELD *fields =mysql_fetch_fields(result);
      vector<string> fieldnames;
      for (int i=0; i<numfields;++i) {
        string t(fields[i].name);
        transform(t.begin(),t.end(),t.begin(),toupper);
        string::iterator j=find(t.begin(),t.end(),' ');
        while (j!=t.end()) {
          *j='_';
	  j=find(j,t.end(),' ');
        }
        fieldnames.push_back(t);
      }
      if (!is_assign) {
        ParamMap values=params;
        while (NULL!=(row=mysql_fetch_row(result))) {
          for (int i=0;i<numfields;++i) {
            if (NULL!=row[i]) {
              values[fieldnames[i]]=Entities::Escape(string(row[i]));
	          } else {
	            values[fieldnames[i]]="";
	          }
          }
          HitopCommands::UserEngine(stream,cur,values,entryproc);
        }
      } else {
        if (NULL!=(row=mysql_fetch_row(result))) { return; }
        for (int i=0;i<numfields;++i) {
          if (NULL!=row[i]) {
            stream.m_curVars.Set(fieldnames[i],Entities::Escape(string(row[i])),Vars::Local);
          } else {
            stream.m_curVars.Set(fieldnames[i],"",Vars::Local);
          }
        }
      }
    }
    mysql_free_result(result);
  }
}


void DBmysql::Disconnect(HTMLStream &stream,HTMLStream::iterator cur,
        const ParamMap& params) {
  
  mysql_close(m_connection);
}

void dsoDBmysqlMod::ESCAPE(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"ESCAPE",e_ParamNone);
  char* buffer = new char[1+2*(data.AsString().length())];
  mysql_escape_string(buffer,data.AsString().c_str(),data.AsString().length());
  data=buffer;
  delete [] buffer;
}
