#include "plugin.h"
#include "error.h"
#include "hitopcore.h"

#include <algorithm>

map<string,Plugin*> *Plugin::s_modulemap;

Plugin::Plugin() {
  if (s_modulemap==NULL)  {
    Plugin::s_modulemap= new map<string,Plugin*>();
  }
}

void Plugin::SetNamespace(const string& name) {
  if (!m_hasNamespace) m_namespace=name;
}

void Plugin::RegisterPlugin(const string& name,int version) {
  m_version=version;
  if (Plugin::s_modulemap->find(name)!=Plugin::s_modulemap->end()) {
    Error("Module name conflict detected: "+name);
  }
  Plugin::s_modulemap->insert(make_pair(name,this));
}

void Plugin::RegisterCommand(const string& name,CommandFunc proc) {
  string fullname;
  if (!m_namespace.empty()) {
    fullname = "@"+m_namespace+"."+name;
  } else {
    fullname = "@"+name;
  }
  if(!g_isXML) transform(fullname.begin(),fullname.end(),fullname.begin(),toupper);
  HTMLStream::RegisterCommand(fullname,proc);
}

void Plugin::RegisterFunction (const string& name,FunctionFunc proc) {
  string fullname;
  if (!m_namespace.empty()) {
    fullname = m_namespace+"."+name;
  } else {
    fullname = name;
  }
  if(!g_isXML) transform(fullname.begin(),fullname.end(),fullname.begin(),toupper);
  StringProc::RegisterFunction(fullname,proc);
}

void Plugin::RegisterDBDriver(const string& name, const DBManager::ConnectFn proc) {
  string fullname;
  if (!m_namespace.empty()) {
    fullname = m_namespace;
  } else {
    fullname = name;
  }
  if(!g_isXML) transform(fullname.begin(),fullname.end(),fullname.begin(),toupper);
  DBManager::RegisterDriver(fullname,proc);
}

