#ifndef __htmlh__
#define __htmlh__

#ifndef __varsh__
  #include "vars.h"
#endif
#ifndef __tokenmaph__
  #include "tokenmap.h"
#endif
#ifndef __dtutilsh__
  #include "dtutils.h"
#endif

#include <iostream>
#include <map>
#include <list>
#include <string>

class ParamMap;

class HTML{
  friend class HTMLStream;
  friend class HitopCommands;
  friend ostream& operator<<(ostream& out,const HTMLStream& html);
public:
  HTML(bool isMarkup,const string& content):m_isMarkup(isMarkup),m_preformat(false),
    m_content(content),m_line(0){if(m_isMarkup){UpdateCache();CheckExpandable();}}
  HTML(const string& fname,int line,bool isMarkup,const string& content):
    m_isMarkup(isMarkup),m_preformat(false),m_content(content),m_fname(fname),m_line(line){
    if(isMarkup){UpdateCache();CheckExpandable();}
  }

  HTML(const HTML& original):m_myPair(NULL),m_myElse(NULL),
    m_isMarkup(original.m_isMarkup),m_preformat(original.m_preformat),
    m_content(original.m_content),m_tagName(original.m_tagName),
    m_token(original.m_token),m_firstChar(original.m_firstChar),
    m_isExpandable(original.m_isExpandable),m_fname(original.m_fname),
    m_line(original.m_line){}
  HTML& operator=(const HTML& original);
  string Print()const;
  string TagName()const{return m_tagName;}
  void ImposeText(const string& content){
    m_content=content;
    m_isMarkup=false;
  }
  void BuildParamMap(ParamMap& paramMap)const;
  void ExpandVariables(const Vars& vars){
    if(m_isExpandable) ExpandVariablesEngine(vars);
  }
  void AppendToContent(const string& st);
  void DropFirstChar();
  char FirstChar()const{return m_firstChar;}
  int Token()const{if(m_isMarkup) return m_token; return -1;}

  bool IsMarkup()const{return m_isMarkup;}
  string Origin()const{return m_fname+":"+IToS(m_line);}
  void SetPreformat(bool val){m_preformat=val;}
private:
  list<HTML>::iterator m_myPair,m_myElse;
  void ExpandVariablesEngine(const Vars& vars);
  void UpdateCache();
  void CheckExpandable();

  bool m_isMarkup;
  bool m_preformat;
  string m_content,m_tagName;
  int m_token;
  char m_firstChar;
  bool m_isExpandable;
  string m_fname;
  int m_line;
};

#endif
