// hitop - an HTML preprocessor
// Copyright 1997-2001 David Marshall & Darren Edmundson

#include "hitopcore.h"
#include "hitopcommands.h"
#include "htmlstream.h"
#include "tables/tables.h"

#include <iostream>
#include <fstream>
#include <sys/types.h>
#include <sys/stat.h>

const string g_version("0.35");
const string g_dateISO("2001-06-10");
const string g_years("1997-2001");
const bool g_isXML=false;
const bool g_isHTML=true;
string g_contentType("text/html");

multimap<string,string> g_httpHeader;
string g_statusHeader;

string replicate(const string& a,int n){
  string temp;
  for(int i=0;i<n;++i) temp+=a;
  return temp;
}

static string DateFormat(const string& Format,tm *NowBreak){
  char Date[20];
  strftime(Date,20,Format.c_str(),NowBreak);
  return Date;
}

void DoVars(HTMLStream *Main){
  InitTables();
  HitopCommands::Init();
  time_t Now=time(NULL);
  tm* NowBreak=localtime(&Now);
  Main->SetVar("DATE",DateFormat("%Y-%m-%d",NowBreak),Vars::Global);
  Main->SetVar("DATEYEAR",DateFormat("%Y",NowBreak),Vars::Global);
  Main->SetVar("DATEMONTH",DateFormat("%m",NowBreak),Vars::Global);
  Main->SetVar("DATEDAY",DateFormat("%d",NowBreak),Vars::Global);
  Main->SetVar("TIME",DateFormat("%H:%M:%S",NowBreak),Vars::Global);
  Main->SetVar("TIMEHOUR",DateFormat("%H",NowBreak),Vars::Global);
  Main->SetVar("TIMEMINUTE",DateFormat("%M",NowBreak),Vars::Global);
  Main->SetVar("TIMESECOND",DateFormat("%S",NowBreak),Vars::Global);
}

bool ParseArgs(int argn,char* argc[],string& inFile,string& outFile){
  if(argn==3){
    inFile=argc[1];
    outFile=argc[2];
    return true;
  }else if(argn==2){
    inFile=argc[1];
    outFile=inFile;
    string::size_type len=outFile.length();
    if(len>6){
      int pos=len-6;
      if(outFile.substr(pos,6)==".hitop"){
        outFile.replace(pos,6,".html");
        return true;
      }
    }
  }
  return false;
}
