#include "dbmgr.h"
#ifndef __htmlh__
  #include "html.h"
#endif
#ifndef __parammaph__
  #include "parammap.h"
#endif
#ifndef __errorh__
  #include "error.h"
#endif
#ifndef __defstoreh__
  #include "defstore.h"
#endif

#include <algorithm>

map <string,DBManager::ConnectFn> DBManager::s_drivers;
map <string,DBaseBase*> DBManager::s_connections;


HTMLStream::iterator DBManager::Connect(HTMLStream& stream, HTMLStream::iterator cur,
    const ParamMap& paramMap,const string& tag) {
  string dbdriver,dbhandle;
  if (!paramMap.Retrieve("USING",dbdriver)) {
    Error(*cur,"Missing USING parameter");
  }
  if (!paramMap.Retrieve("HANDLE",dbhandle)) {
    Error(*cur,"Missing HANDLE parameter");
  }
  if(!g_isXML){
    transform(dbdriver.begin(),dbdriver.end(),dbdriver.begin(),toupper);
    transform(dbhandle.begin(),dbhandle.end(),dbhandle.begin(),toupper);
  }
  map<string,ConnectFn>::iterator fn=s_drivers.find(dbdriver);
  if (fn==s_drivers.end()) {
    Error(*cur,"Unknown Database driver requested. Perhaps you need to @REQUIRE it?");
  }
  map<string,DBaseBase*>::iterator oldmap=s_connections.find(dbhandle);
  if (oldmap!=s_connections.end()) {
    oldmap->second->Disconnect(stream,cur,ParamMap());
    delete oldmap->second;
  }
  s_connections[dbhandle]=(fn->second)(dbhandle,stream,cur,paramMap);
  HTMLStream::iterator next=cur;
  ++next;
  stream.m_stream.erase(cur);
  return next;
}

HTMLStream::iterator DBManager::Query(HTMLStream& stream, HTMLStream::iterator cur,
    const ParamMap& paramMap,const string& tag) {
  string dbhandle;
  if (!paramMap.Retrieve("HANDLE",dbhandle)) {
    Error(*cur,"Missing HANDLE parameter"); 
  }
  if(!g_isXML) transform(dbhandle.begin(),dbhandle.end(),dbhandle.begin(),toupper);
  map<string,DBaseBase*>::iterator connection=s_connections.find(dbhandle);
  if (connection==s_connections.end()) {
    Error(*cur,"Handle parameter is not connected to a database");
  }
  bool is_assign = paramMap.Test("ASSIGN");
  bool is_discard = paramMap.Test("DISCARD");
  string entryproc;
  if (!paramMap.Retrieve("ENTRY",entryproc) && !is_discard && !is_assign) {
    Error(*cur,"One of ENTRY, ASSIGN or DISCARD must be given");
  }
  TokenMap::Token token=TokenMap::NameToTokenNum(entryproc);
  if (!is_discard && !is_assign && !DEFStore::Exists(token)) {
    Error(*cur,"ENTRY parameter is not a defined procedure");
  }
  connection->second->Query(stream,cur,entryproc,paramMap,is_discard,is_assign);
  HTMLStream::iterator next=cur;
  ++next;
  stream.m_stream.erase(cur);
  return next;
}

HTMLStream::iterator DBManager::Disconnect(HTMLStream& stream, HTMLStream::iterator cur,
    const ParamMap& paramMap,const string& tag) {
  string dbhandle;
  if (!paramMap.Retrieve("HANDLE",dbhandle)) {
    Error(*cur,"Missing HANDLE parameter to DISCONNECT");
  }
  if(!g_isXML) transform(dbhandle.begin(),dbhandle.end(),dbhandle.begin(),toupper);
  map<string,DBaseBase*>::iterator connection= s_connections.find (dbhandle);
  if  (connection==s_connections.end()) {
    Error(*cur,"HANDLE parameter is not connected to a database");
  }
  connection->second->Disconnect(stream,cur,paramMap);
  delete connection->second;
  s_connections.erase(connection);
  HTMLStream::iterator next=cur;
  ++next;
  stream.m_stream.erase(cur);
  return next;
}

void DBManager::RegisterDriver(string drivername,ConnectFn connector) {
  if(!g_isXML) transform(drivername.begin(),drivername.end(),drivername.begin(),toupper);
  map<string,ConnectFn>::iterator fn=s_drivers.find(drivername);
  if (fn!=s_drivers.end()) {
    Error("A database driver name conflict has been detected");
  }
  s_drivers[drivername]=connector; 
}

