/*
 * Exemplo para kernel 2.6
 *
 *
 *Inclusoes de arquivos
 * module.h - necessario para todos os modulos do kernel
 * kernel.h - contem algumas macros interessantes
 * init.h - tambem contem macros interessantes
 */
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>

/*
 * Definicoes que indicam ao compilador que o programa rodara no 
 * kernel-space, e nao no user-space
 */

#ifndef __KERNEL__
#define __KERNEL__
#endif
#ifndef MODULE
#define MODULE
#endif

/*
 * Apartir do kernel 2.4 podemos dar nomes proprios para nossas funcoes, e 
 * indicar posteriormente que sao inicio/fim do modulo
 */
static int __init hello(void){
 printk(KERN_ALERT,"Hello World\n");
 return 0;
}

static void bye(void){
 printk(KERN_ALERT,"Bye World");
}

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Bruno");
MODULE_DESCRIPTION("Exemplo de modulo para kernel 2.6/2.4");
module_init("hello");
module_cleanup("bye");

