#include <iostream>
#include <map>
#include <list>
#include <string>

using namespace std;

// Cores dos nodos
const string PRETO = "preto";
const string BRANCO = "branco";
const string CINZA = "cinza";

// Definicao do tipo usado para a Lista de Adjacencias
typedef list<int> listaAdjacencias;

// Definicao do tipo grafo, Vetor de Listas de Adjacencias
typedef map<int, listaAdjacencias> grafo;

// Tabela de cores dos nodos
map<int, string> cor;

// Lista de Ordenacao Topologica
list<int> ordemTopologica;



// Visita um nodo ate o nivel mais baixo do grafo
void visitarNodo(grafo G, int u)
{
	// PARA TESTES
	// cout << "nodo : " << u << endl;
	cor[u] = CINZA;

	// Visita do nodo
	for(listaAdjacencias::iterator i = G[u].begin(); i != G[u].end(); i++)
	{
		if ( cor[ *i ] == BRANCO )
			visitarNodo(G, *i);
	}

	cor[u] = PRETO;						// O nodo eh marcado como visitado

	ordemTopologica.push_back(u);		// O nodo eh inserido na Lista 
										// de Ordenacao Topologica
	// PARA TESTES
	// cout << "- " << u << endl;
}

// Busca em profundidade
void buscaProfundidade(grafo G)
{
	// Inicializacao da tabela de cores
	for(grafo::iterator i = G.begin(); i != G.end(); ++i)
		cor[i->first] = BRANCO;

	// Visitar cada nodo
	for(grafo::iterator i = G.begin(); i != G.end(); ++i)
	{
		if ( cor[i->first] == BRANCO )
		{
			visitarNodo(G, i->first);
		}
	}
}


// Verificacao de um DAG - se tem ciclo 
int temCiclo(grafo G)
{
	list<int>::iterator i, j;

	// Busca em profundidade elog v
	buscaProfundidade(G);

	for(i = ordemTopologica.begin(); i != ordemTopologica.end(); i++)
	{
		// Verificacao de ciclos no grafo - custo quad
		j = i;
		for(++j; j != ordemTopologica.end(); j++)
			if (  find(G[*i].begin(), G[*i].end(), *j) != G[*i].end()  )
				return(0);
	}

	return(1);
}

// ---- PROGRAMA PRINCIPAL ---- //
int main(int argc, char *argv[])
{
	if (argc != 2)
	{
		cout << "Erro!" << endl;
		cout << "Uso: " << argv[0] << " nome_do_arquivo.txt" << endl;
		exit(1);
	}

	FILE *arquivo;  // Arquivo contendo o grafo

	grafo G;							// Grafo do tipo Lista de Adjacencias
	int no, aresta;

	// Abrindo o arquivo texto para leitura do grafo
	if( (arquivo = fopen (argv[1], "r")) == NULL )
	{
		cout << "\n\n Erro na leitura do arquivo." << endl;
		exit(1);
	}

	// Leitura do grafo no arquivo texto
	while( !feof(arquivo) )
	{
		fscanf(arquivo,"%d %d", &no, &aresta);
		
		if ( G[no].empty() )
			G[no] = listaAdjacencias();
		if ( G[aresta].empty() )
			G[aresta] = listaAdjacencias();

		G[no].push_back(aresta);
	}

	// Fechando o arquivo texto
	fclose(arquivo);

	// Ordenando as Listas de Adjacencias
	for(grafo::iterator i = G.begin(); i != G.end(); ++i)
		if ( ! (i->second).empty() )
			(i->second).sort();

	// Verificacao de ciclos no grafo
	if ( temCiclo(G) == 1 )
		cout << "grafo aciclico" << endl;
	else
		cout << "ha ciclos" << endl;

	return(0);
}
// ---- PROGRAMA PRINCIPAL ---- //
