#include "conf.h"

int main(void)
{
	//int i;
	//char **tuple;
	Database *db;
	DBResult *res;

	db = new Database();

	cgi C;
        C.initPage();

	Pro p;

	string instance;
        instance = C.get_value("instance");
	config CONF(instance);
	
	const char* MYDATABASE;
        const char* MYTOPIC;
        const char* MYANSWER;
        const char* MYQUESTION;
        const char* USER;
        const char* PASS;
        const char* HOST;
        HOST = CONF.HOST.c_str();
	USER = CONF.USER.c_str();
        PASS = CONF.PASS.c_str(); 
        MYDATABASE = CONF.MYDATABASE.c_str();
        MYTOPIC = CONF.MYTOPIC.c_str();
        MYANSWER = CONF.MYANSWER.c_str();
        MYQUESTION = CONF.MYQUESTION.c_str();

	// Initialise the database - for future releases
	if (db->init() != DB_COMMAND_OK) {
		fprintf(stdout, "Unable to initialize database: %s\n\n", 
		        db->errorMessage());
		exit(0);
        }

	string topic;
	string stage;
	stage = C.get_value("stage");
	topic = C.get_value("topic");

	HTML h;
        cout << h.html()
        << h.body("#ffffff") << endl;

	if( stage == "prepare" )
	{
		string url;
		url = string(URL) + "/" + string(ADMIN) + "/topic.cgi";
		cout << h.title("Add Topic") << endl
		<< "<h2>Database Instance: " << instance << "</h2>" << endl
		<< h.form( "store", url, "POST") << endl
		<< h.font("arial","2") << "Topic:" << h._font() << "<br></br>" << endl		
		<< h.textarea("topic", "", "4", "30") << "<br></br>" << endl
		<< "<input type=hidden name=instance value=\"" << instance << "\">\n"
		<< h.in_submit("Save") << endl
		<< h._form() << endl;
	}
	else
	{
		// Connect to database on localhost
		if (db->connect(HOST, "", MYDATABASE, USER, PASS) != DB_CONNECTION_OK) { 
			fprintf(stdout, "Unable connect to database '%s': %s\n\n", 
			        MYDATABASE, db->errorMessage());
			exit(0);
		}

		string tmp("");
		tmp = p.parse(topic);

		res = db->exec("INSERT INTO %s VALUES(0, '%s')",MYTOPIC, tmp.c_str());
		if (res->status() != DB_COMMAND_OK) {
			fprintf(stdout, "Can't insert into table '%s': %s\n\n", MYTOPIC, db->errorMessage());
			delete res;
			delete db;
			exit(0);
		}
		
		cout << "Data inserted\n"
		<< p.back("dbadmin", instance);
	}
	cout << h._body()
	<< h._html()
	<< endl;	

	delete res;			// Drop buffer
	delete db;			// Close connection
}
