#include "conf.h"

int main(void)
{
	//int i;
	char **tuple;
	Database *db;
	DBResult *res;

	db = new Database();

	cgi C;
        C.initPage();

	string instance;
        instance = C.get_value("instance");
        config CONF(instance);

	const char* MYDATABASE;
        const char* MYTOPIC;
        const char* MYANSWER;
        const char* MYQUESTION;
        const char* USER;
        const char* PASS;
        const char* HOST;
        HOST = CONF.HOST.c_str();
	USER = CONF.USER.c_str();
        PASS = CONF.PASS.c_str(); 
        MYDATABASE = CONF.MYDATABASE.c_str();
        MYTOPIC = CONF.MYTOPIC.c_str();
        MYANSWER = CONF.MYANSWER.c_str();
        MYQUESTION = CONF.MYQUESTION.c_str();

	// Initialise the database - for future releases
	if (db->init() != DB_COMMAND_OK) {
		fprintf(stdout, "Unable to initialize database: %s\n\n", 
		        db->errorMessage());
		exit(0);
        }

	string stage;
	stage = C.get_value("stage");
		

	// Connect to database on localhost
	if (db->connect(HOST, "", MYDATABASE, USER, PASS) != DB_CONNECTION_OK) { 
		fprintf(stdout, "Unable connect to database '%s': %s\n\n", 
		        MYDATABASE, db->errorMessage());
		exit(0);
	}

	HTML h;
	cout << h.html()
        << h.body("ffffff") << endl;
	if(stage == "prepare")
	{
		string url("");
		url = string(URL) + "/search.cgi";
		cout << "<h2>Search the database</h2>\n"
		<< h.font("arial","2") << endl
		<< "Please enter your search query:\n<br></br>"
		<< h.form( "search", url, "POST") << endl
		<< h.textarea("expression", "", "2", "30") << "<br></br>" << endl
		<< "Select a search method:<br>"
		<< "<input type=radio name=mode value=PHRASE checked> An exact phrase match<br>\n"
		<< "<input type=radio name=mode value=AND> Matches on all words (AND)<br>\n"
		<< "<input type=radio name=mode value=OR> Matches on any word (OR)<br>\n"
		<< "<input type=hidden name=instance value=\"" << instance << "\">\n"
		<< "<br></br>\n"
		<< "<input type=radio name=keymode value=KEY checked> Search only in \"keywords\"<br>\n"
		<< "<input type=radio name=keymode value=ALL> Search the whole database<br>\n"
		<< h.in_submit(" Search ") << endl
                << h._form() << endl	
		<< h._body()
		<< h._html()
		<< endl;	
	}
	else
	{
		string expression, mode, keymode, usemode, tmp("");
		expression = C.get_value("expression");
		if(expression == "")
		{	
			cout << "Nothing to search!<br></br>\n";
			cout << "<A HREF=\"" << URL << "/search.cgi?instance=" 
			<< instance << "&stage=prepare" << "\">[ new search ]</A>\n";
			cout << h._body() << h._html();
			exit(0);
		}
		mode = C.get_value("mode");
		keymode = C.get_value("keymode");
		int len, count=0;
		len = expression.length();
		tmp = "SELECT DISTINCT question_id from ";
		tmp += string(MYANSWER) + " WHERE ";
		if(mode != "PHRASE")
		{
			if(keymode == "ALL")
				tmp += "(value like '%";
			else
                        	tmp += "keywords like '%";
			
			for(int i=0;i<len;i++)
			{
				if(expression[i] == ' ')
				{
					if(keymode == "ALL")
					{
						tmp += "%') " + mode;
						tmp += " (value like '%";
					}
					else
					{
                                                tmp += "%' " + mode;
                                                tmp += " keywords like '%";
                                        }
				}
				else 
					tmp += expression[i];
					
			}
			if(keymode == "ALL")
				tmp += "%')";
			else
				tmp += "%'";
		}
		else
		{
			if(keymode == "ALL")
                        	tmp += "value like '%";
			else
				tmp += "keywords like '%";
			tmp += expression + "%'";
		}
		cout << "<h2>Search Results:</h2>";
		res = db->exec("%s", tmp.c_str());
		tuple = res->getTuple();
        	while (tuple != NULL)
		{
			count++;
			tuple = res->getTuple();
        	}
		cout << "<p>" << h.font("arial","2")
		<< count << " ";
		if(count <= 1)
			cout << "match";
		else
			cout << "matches"; 

		cout << " found in database:</p>" << h._font();
		cout << "<hr>\n";
		int i=0;
		string answer_id[count+1], question_id[count+1];
		db->exec(res, "%s", tmp.c_str()); 
		tuple = res->getTuple();
		while (tuple != NULL)
		{
			question_id[i] = *(tuple);
			tuple = res->getTuple();
			i++;
		}	

		
		// start to output the results:
		i = 0;

		for(int c=0; c<count;c++)
		{
			db->exec(res, "SELECT value FROM %s WHERE question_id = %s", MYQUESTION, question_id[c].c_str());
			tuple = res->getTuple();
			while (tuple != NULL)
			{
				cout << h.font("arial","2")
                                << "<A HREF=\"" << URL << "/getanswer.cgi?instance=" << instance << "&question_id="
                                << question_id[c] << "\">" << *(tuple)
                                << "</A><br></br>" << h._font() << endl;
                                tuple = res->getTuple();
			}
		}
		cout << "<hr>\n";
		cout << "<A HREF=\"" << URL << "/search.cgi?instance=" << instance << "&stage=prepare"
		<< "\">[ new search ]</A>\n";
		cout << h._body() << endl
                << h._html();	
	}


	delete res;			// Drop buffer
	delete db;			// Close connection

}
