#include "conf.h"

int main(void)
{
	//int i;
	char **tuple;
	Database *db;
	DBResult *res;

	db = new Database();

	cgi C;
        C.initPage();

	Pro p;

        string instance;
        instance = C.get_value("instance");
        config CONF(instance);

	const char* MYDATABASE;
        const char* MYTOPIC;
        const char* MYANSWER;
        const char* MYQUESTION;
        const char* USER;
        const char* PASS;
        const char* HOST;
        HOST = CONF.HOST.c_str();
	USER = CONF.USER.c_str();
        PASS = CONF.PASS.c_str(); 
        MYDATABASE = CONF.MYDATABASE.c_str();
        MYTOPIC = CONF.MYTOPIC.c_str();
        MYANSWER = CONF.MYANSWER.c_str();
        MYQUESTION = CONF.MYQUESTION.c_str();

	// Initialise the database - for future releases
	if (db->init() != DB_COMMAND_OK) {
		fprintf(stdout, "Unable to initialize database: %s\n\n", 
		        db->errorMessage());
		exit(0);
        }

        if (db->connect(HOST, "", MYDATABASE, USER, PASS) != DB_CONNECTION_OK) {
                fprintf(stdout, "Unable connect to database '%s': %s\n\n",
                MYDATABASE, db->errorMessage());
                exit(0);
        }
	
	string stage;
	string topic_id;
        topic_id = C.get_value("topic_id");
	stage = C.get_value("stage");

	HTML h;

	cout << h.html()
        << h.body("#ffffff") << endl;

	if( stage == "prepare" )
	{
		res = db->exec("SELECT value FROM %s WHERE topic_id = '%s'", MYTOPIC, topic_id.c_str());
                tuple = res->getTuple();
                while (tuple != NULL)
                {
                        cout << "<h2>" << *(tuple) << "</h2>\n";
                        tuple = res->getTuple();
                }
		cout << "<form name=ask action=\"" << URL << "/" << ADMIN << "/question.cgi\" method=post>" << endl
		<< h.font("arial","2")
		<< "Enter new question:"
		<< h._font() << "<br></br>" << endl
		<< h.font("arial","2") << "Question:" << h._font() << "<br></br>" << endl
		<< h.textarea("question", "", "8", "60") << "<br></br>" << endl
		<< h.font("arial","2") << "Keywords:" << h._font() << "<br></br>" << endl
		<< h.textarea("keys", "", "4", "30") << "<br></br>" << endl
		<< h.in_hidden("topic_id", topic_id) << endl
		<< "<input type=hidden name=instance value=\"" << instance << "\">\n"
		<< h.in_hidden("stage", "save") << endl
		<< h.in_submit("Save") 
		<< h.in_reset("Clear") << endl
		<< h._form() << endl;
	}
	else
	{
		string ques, ke, question, keys;
		ques = C.get_value("question");
		if( ques == "" )
		{
			cout << h.title("Error!")
			<< "<h2>Value for \"QUESTION\" was empty!</h2>" << endl;
		}
		else
		{
			ke = C.get_value("keys");	
			
			question = p.parse(ques);
			keys = p.parse(ke);
	
			res = db->exec("INSERT INTO %s VALUES(0, %s, '%s', '%s')",MYQUESTION, topic_id.c_str(), question.c_str(), keys.c_str());
			if (res->status() != DB_COMMAND_OK) {
				fprintf(stdout, "Can't insert into table '%s': %s\n\n", MYQUESTION, db->errorMessage());
				delete res;
				delete db;
				exit(0);
			}
			cout << "Data inserted<br></br>\n";
			cout << p.back("dbadmin", instance) << endl;
		}
	}
	cout << h._body()
	<< h._html()
	<< endl;	
	delete res;			// Drop buffer
	delete db;			// Close connection
}
