#include "conf.h"

int main(void)
{
        //int i;
        char **tuple;
        Database *db;
        DBResult *res;

        db = new Database();

	cgi C;
        C.initPage();

	string instance;
        instance = C.get_value("instance");
        config CONF(instance);

	const char* MYDATABASE;
        const char* MYTOPIC;
        const char* MYANSWER;
        const char* MYQUESTION;
        const char* USER;
        const char* PASS;
        const char* HOST;
        HOST = CONF.HOST.c_str();
        USER = CONF.USER.c_str();
        PASS = CONF.PASS.c_str(); 
        MYDATABASE = CONF.MYDATABASE.c_str();
        MYTOPIC = CONF.MYTOPIC.c_str();
        MYANSWER = CONF.MYANSWER.c_str();
        MYQUESTION = CONF.MYQUESTION.c_str();

        string stage, mode, answer, topic, question, question_id, answer_id, topic_id, keys;
	string TABLE, hidden_mode, hidden_id, id, action, value;
	
	if (db->init() != DB_COMMAND_OK) {
                fprintf(stdout, "Unable to initialize database: %s\n\n",
                        db->errorMessage());
                exit(0);
        }

        // Connect to database on localhost
	if (db->connect(HOST, "", MYDATABASE, USER, PASS) != DB_CONNECTION_OK) { 
                fprintf(stdout, "Unable connect to database '%s': %s\n\n",
                        MYDATABASE, db->errorMessage());
                exit(0);
        } 

	stage = C.get_value("stage");
	mode = C.get_value("mode");

	HTML h;
	
	cout << h.html() << h.body("#ffffff") << endl;

	if (stage == "prepare")
	{
		if (mode == "topic")
		{
			topic_id = C.get_value("topic_id");
			hidden_id = topic_id;
			TABLE = MYTOPIC;
		}
		else if (mode == "question")
		{
			question_id = C.get_value("question_id");
			hidden_id = question_id;
			TABLE = MYQUESTION;
		}
		else if (mode == "answer")
		{
			answer_id = C.get_value("answer_id");
			hidden_id = answer_id;
			TABLE = MYANSWER;
		}

		id = mode + "_id";

		res = db->exec("SELECT value FROM %s WHERE %s = %s", TABLE.c_str(), id.c_str(), hidden_id.c_str());
                tuple = res->getTuple();
                while (tuple != NULL)
                {
                        value = *(tuple);
			tuple = res->getTuple();
                }


                cout << "<form name=modify action=\"" << URL << "/" << ADMIN << "/modify.cgi\" method=post>" << endl
                << h.font("arial","2")
                << "<b>Modify a " << mode << ".</b>"
                << h._font() << "<br></br>" << endl
                << h.font("arial","2") << mode << ": " << h._font() << "<br></br>" << endl
                << h.textarea(mode, value, "15", "80") << "<br></br>" << endl;
		if (mode != "topic")
		{
			db->exec(res,"SELECT keywords FROM %s WHERE %s = %s", TABLE.c_str(), id.c_str(), hidden_id.c_str());
                	tuple = res->getTuple();
                	while (tuple != NULL)
                	{
                	        keys = *(tuple);
                	        tuple = res->getTuple();
                	}
			cout << h.font("arial","2") << "key words: " << h._font() << "<br></br>" << endl 	
			<< h.textarea("keys", keys, "4", "30") << "<br></br>" << endl;
		}
                cout << h.in_hidden(id, hidden_id) << endl
		<< h.in_hidden("mode", mode) << endl
		<< h.in_hidden("stage", "save") << endl
                << h.in_submit("Modify")
		<< h.in_hidden("instance",instance)
                << h.in_reset("Clear") << endl
                << h._form() << endl; 
	}
	else
	{
		// Modify stage
		if (mode == "topic")
                {
                        hidden_id = C.get_value("topic_id");
                        value = C.get_value("topic");
                        TABLE = MYTOPIC;
                }
                else if (mode == "question")
                {
                        hidden_id = C.get_value("question_id");
                        value = C.get_value("question");
                        TABLE = MYQUESTION;
                }
                else if (mode == "answer")
                {
                        hidden_id = C.get_value("answer_id");
                        value = C.get_value("answer");
                        TABLE = MYANSWER;
                }
		

		id = mode + "_id";

		string tmp("");
		int len;
		len = value.length();
		for(int i=0;i<len;i++)
		{
			if(value[i] == char(39))
				tmp += "\\'";
			else
				tmp += value[i];
		}
	
		res = db->exec("UPDATE %s SET value = '%s' WHERE %s = %s", TABLE.c_str(), tmp.c_str(), id.c_str(), hidden_id.c_str()); 
		if (res->status() != DB_COMMAND_OK) {
                fprintf(stdout, "Can't update into table '%s': %s\n\n", TABLE.c_str(), db->errorMessage());
                        delete res;
                        delete db;
                        exit(0);
                }
/*
		cout << "Command: <b><br>" << endl;
		fprintf(stdout, "UPDATE %s SET keys = '%s' WHERE %s = %s", TABLE.c_str(), keys.c_str(), id.c_str(), hidden_id.c_str());
		cout << "</b><br></br>\n";
*/		

		if (mode != "topic")
		{
			keys = C.get_value("keys");
			db->exec(res, "UPDATE %s SET keywords = '%s' WHERE %s = %s", TABLE.c_str(), keys.c_str(), id.c_str(), hidden_id.c_str());
                	if (res->status() != DB_COMMAND_OK) {
                	fprintf(stdout, "Can't update into table '%s': %s\n\n", TABLE.c_str(), db->errorMessage());
                	        delete res;
                	        delete db;
                	        exit(0);
                	}
		} 
	
		cout << "<b>Data in table \"" << TABLE << "\" updated</b><br></br>\n";
	}
	Pro p; 
	cout << p.back("dbadmin", instance) << endl;
	cout << h._body() << h._html() << endl;

}
