
/*
 * here we define some handy html outputs
 * so we don't have to hack too much :-)
 */

class HTML
{
	public:
        /*
         * the constructor
         */
        HTML()
	{;}

	/*
	 * some handy vars/functions
	 * the naming convention:
	 * a function without underscore, like body() is the start-tag
	 * i.e. <body>, a functionname with underscore is the end, i.e. 
	 * </body>
	 * if you cannot find a undersore-function, the exiting one
	 * includes both tags, i.e. title.
	 */
	string html();
        string _html();

	string body(const string& bgcolor, const string& text, const string& link, const string& vlink, const string& alink);
	string body(const string& bgcolor);
	string body();
	string _body();

	string title(const string& title);

	string hx(const string& title, const string& size);
	
	string bold();
	string _bold();

	string font(const string& face, const string& size);
	string _font();

	string center();
	string _center();

	string table(const string& border, const string& bgcolor, const string& width);
	string _table();
	
	string tr();
	string _tr();

	string th(const string& colspan, const string& bgcolor);
	string th(const string& height);
	string _th();

	string td(const string& bgcolor, const string& align, const string& valign);
	string td(const string& bgcolor, const string& align);
	string td(const string& bgcolor);
	string td();
	string _td();

	string form(const string& name, const string& action, const string& method);
	string _form();

	string in_text(const string& name, const string& value);
	string textarea(const string& name, const string& value, const string& row, const string& cols);
	string textarea(const string& name, const string& value);
	string in_password(const string& name, const string& value);
	string in_file(const string& name, const string& value);
	string in_select(const string& name, string option[], const string& selected, const int& num);
	string in_hidden(const string& name, const string& value);
	string in_submit(const string& value);
	string in_reset(const string& reset);
};

string HTML::html()
{
	return "<html>";
}

string HTML::_html()
{
	return "</html>";
}

string HTML::body()
{
	return "<body>";
}


string HTML::body(const string& bgcolor, const string& text, const string& link, const string& vlink, const string& alink)
{
	string tmp("<body bgcolor=\"");
	tmp.append(bgcolor);
	tmp.append("\" text=\"");
	tmp.append(text);
	tmp.append("\" link=\"");
	tmp.append(link);
	tmp.append("\" vlink=\"");
	tmp.append(vlink);
	tmp.append("\" alink=\"");
	tmp.append(alink);
	tmp.append("\">");
	return tmp;
}


string HTML::body(const string& bgcolor)
{
	string tmp("<body bgcolor=\"");
        tmp.append(bgcolor);
        tmp.append("\">");
        return tmp;
}


string HTML::_body()
{
	return "</body>";
}

string HTML::title(const string& title)
{
	string tmp("<title>");
	tmp.append(title);
	tmp.append("</title>");
	return tmp;
}

string HTML::hx(const string& title, const string& size)
{
	string tmp("<h");
	tmp.append(size);
	tmp.append(">");
	tmp.append(title);
	tmp.append("</h");
	tmp.append(size);
	tmp.append(">");
	return tmp;
}


string HTML::font(const string& face, const string& size)
{
	string tmp("<font face=\"");
	tmp.append(face);
	tmp.append("\" size=\"");
	tmp.append(size);
	tmp.append("\">");
	return tmp;
}



string HTML::_font()
{
	return "</font>";
}

string HTML::center()
{
	return "<center";
}

string HTML::_center()
{
	return "</center>";
}



string HTML::table(const string& border, const string& bgcolor, const string& width)
{
	string tmp("<table border=\"");
	tmp.append(border);
	tmp.append("\" bgcolor=\"");
	tmp.append(bgcolor);
	tmp.append("\" width=\"");
	tmp.append(width);
	tmp.append("\">");
	return tmp;
}



string HTML::th(const string& colspan, const string& bgcolor)
{
	string tmp("<th colspan=\"");
	tmp.append(colspan);
	tmp.append("\" bgcolor=\"");
	tmp.append(bgcolor);
	tmp.append("\">");
	return tmp;
}


string HTML::th(const string& height)
{
	string tmp("<th height=\"");
	tmp.append(height);
	tmp.append("\">");
	return tmp;
}



string HTML::td(const string& bgcolor, const string& align, const string& valign)
{
	string tmp("<td bgcolor=\"");
	tmp.append(bgcolor);
	tmp.append("\" align=\"");
	tmp.append(align);
	tmp.append("\" valign=\"");
	tmp.append(valign);
	tmp.append("\">");
	return tmp;
}



string HTML::td(const string& bgcolor, const string& align)
{
        string tmp("<td bgcolor=\"");
        tmp.append(bgcolor);
        tmp.append("\" align=\"");
        tmp.append(align);
        tmp.append("\">");
        return tmp;
}



string HTML::td(const string& bgcolor)
{
        string tmp("<td bgcolor=\"");
        tmp.append(bgcolor);
        tmp.append("\">");
        return tmp;
}

string HTML::_table()
{
	return "</table>";
}

string HTML::tr()
{
	return "<tr>";
}

string HTML::_tr()
{
	return "</tr>";
}

string HTML::_th()
{
	return "</th>";
}

string HTML::td()
{
	return "<td>";
}

string HTML::_td()
{
	return "</td>";
}

string HTML::_form()
{
	return "</form>";
}





string HTML::form(const string& name, const string& action, const string& method)
{
	string tmp("<form name=\"");
	tmp.append(name);
	tmp.append("\" action=\"");
	tmp.append(action);
	tmp.append("\" method=\"");
	tmp.append(method);
	tmp.append("\">");
	return tmp;
}



string HTML::in_text(const string& name, const string& value)
{
	string tmp("<input type=text name=\"");
	tmp.append(name);
	tmp.append("\" value=\"");
	tmp.append(value);
	tmp.append("\">");
	return tmp;
}


string HTML::textarea(const string& name, const string& value, const string& row, const string& cols)
{
	string tmp("<textarea name=\"");
        tmp.append(name);
	tmp.append("\" rows=\"");
	tmp.append(row);
	tmp.append("\" cols=\"");
	tmp.append(cols);
	tmp.append("\" wrap=\"virtual\">");
	tmp.append(value);
	tmp.append("</textarea>");
	return tmp;
}



string HTML::textarea(const string& name, const string& value)
{
	string tmp("<input type=textarea name=\"");
        tmp.append(name);
        tmp.append("\" value=\"");
        tmp.append(value);
	tmp.append("\">");
        return tmp;
}


string HTML::in_password(const string& name, const string& value)
{
	string tmp("<input type=password name=\"");
        tmp.append(name);
        tmp.append("\" value=\"");
        tmp.append(value);
        tmp.append("\">");
        return tmp;
}


string HTML::in_file(const string& name, const string& value)
{
	string tmp("<input type=file name=\"");
        tmp.append(name);
        tmp.append("\" value=\"");
        tmp.append(value);
        tmp.append("\">");
        return tmp;
}


string HTML::in_select(const string& name, string option[], const string& selected, const int& num)
{
        int i;
        string tmp("<select name=\"");
        tmp.append(name);
        tmp.append("\">\n<option value=\"");
        tmp.append(option[0]);
        tmp.append("\" selected=\"");
        tmp.append(selected);
        tmp.append("\">");
        tmp.append(selected);
        tmp.append("</option>\n");

	for(i=1;i<num;i++)
        {
                tmp.append("<option value=\"");
                tmp.append(option[i]);
                tmp.append("\">");
                tmp.append(option[i]);
                tmp.append("</option>\n");
        }

        tmp.append("</select>");
        return tmp;
}



string HTML::in_hidden(const string& name, const string& value)
{
	string tmp("<input type=hidden name=\"");
        tmp.append(name);
        tmp.append("\" value=\"");
        tmp.append(value);
        tmp.append("\">");
        return tmp;
}


string HTML::in_submit(const string& value)
{
        string tmp("<input type=submit name=submit value=\"");
        tmp.append(value);
        tmp.append("\">");
        return tmp;
}
 
string HTML::in_reset(const string& value)
{
        string tmp("<input type=reset name=reset value=\"");
        tmp.append(value);
        tmp.append("\">");
        return tmp;
}

