#include "conf.h"

int main(void)
{
        //int i;
        char **tuple;
        Database *db;
        DBResult *res;

        db = new Database();

	cgi C;
        C.initPage();

	string instance;
        instance = C.get_value("instance");
        config CONF(instance);

	const char* MYDATABASE;
        const char* MYTOPIC;
        const char* MYANSWER;
        const char* MYQUESTION;
        const char* USER;
        const char* PASS;
        const char* HOST;
        HOST = CONF.HOST.c_str();
        USER = CONF.USER.c_str();
        PASS = CONF.PASS.c_str(); 
        MYDATABASE = CONF.MYDATABASE.c_str();
        MYTOPIC = CONF.MYTOPIC.c_str();
        MYANSWER = CONF.MYANSWER.c_str();
        MYQUESTION = CONF.MYQUESTION.c_str();

        string warn, stage, mode, answer, topic, question, question_id, answer_id, topic_id, keys;
	string TABLE, hidden_mode, hidden_id, id, action, value;
	
	if (db->init() != DB_COMMAND_OK) {
                fprintf(stdout, "Unable to initialize database: %s\n\n",
                        db->errorMessage());
                exit(0);
        }

        // Connect to database on localhost
	if (db->connect(HOST, "", MYDATABASE, USER, PASS) != DB_CONNECTION_OK) { 
                fprintf(stdout, "Unable connect to database '%s': %s\n\n",
                        MYDATABASE, db->errorMessage());
                exit(0);
        } 

	stage = C.get_value("stage");
	mode = C.get_value("mode");

	HTML h;
	
	cout << h.html() << h.body("#ffffff") << endl;

		if (mode == "topic")
		{
			topic_id = C.get_value("topic_id");
			hidden_id = topic_id;
			TABLE = MYTOPIC;
			warn = "Warning! You are about to delete a TOPIC! Every related question and it's ";
			warn += "related answers will deleted too!<br><br>";	
		}
		else if (mode == "question")
		{
			question_id = C.get_value("question_id");
			hidden_id = question_id;
			TABLE = MYQUESTION;
			warn = "Warning! You are about to delete a QUESTION! Every related answer will";
			warn += " deleted too!<br><br>";
		}
		else if (mode == "answer")
		{
			answer_id = C.get_value("answer_id");
			hidden_id = answer_id;
			TABLE = MYANSWER;
			warn = "Warning! You are about to delete an ANSWER!<br><br>";
		}
		warn += "<b>Are you sure?</b>\n";
		id = mode + "_id";

	if (stage == "prepare")
	{
		res = db->exec("SELECT value FROM %s WHERE %s = %s", TABLE.c_str(), id.c_str(), hidden_id.c_str());
                tuple = res->getTuple();
                while (tuple != NULL)
                {
                        value = *(tuple);
			tuple = res->getTuple();
                }


                cout << "<form name=modify action=\"" << URL << "/" << ADMIN << "/delete.cgi\" method=post>" << endl
                << "<h2>DELETE " << mode << ": \"" << value << "\"</h2>\n"
                << h.font("arial","2") << "<br></br>" << endl
                << warn << "<br></br>" <<  h._font() << endl;
                
		cout << h.in_hidden(id, hidden_id) << endl
		<< h.in_hidden("mode", mode) << endl
		<< h.in_hidden("stage", "delete") << endl
                << h.in_submit("  DELETE  ")
		<< h.in_hidden("instance",instance)
                << h._form() << endl; 
	}
	else
	{
		int question_max;
		string *qid;
		if(mode == "topic")
		{
			// find out question_max
                	res = db->exec("SELECT question_id FROM %s WHERE topic_id = %s", MYQUESTION, hidden_id.c_str());
                	tuple = res->getTuple();
                	question_max = 0;
                	while (tuple != NULL)
                	{
                	        question_max++;
                	        tuple = res->getTuple();
                	}
			
			qid = new string[question_max];
			int a = 0;
			res = db->exec("SELECT question_id FROM %s WHERE topic_id = %s", MYQUESTION, hidden_id.c_str());
                        tuple = res->getTuple();
			while (tuple != NULL)
			{
				qid[a] = *(tuple);
				a++;
				tuple = res->getTuple();
			}
			
			// Delete all answers:
			for(int m=0; m<question_max; m++)
			{
				db->exec(res, "DELETE from %s WHERE question_id = %s", MYANSWER, qid[m].c_str());
				if (res->status() != DB_COMMAND_OK) {
					fprintf(stdout, "Can't delete answer number: %s. \n %s \n\n", qid[m].c_str(), db->errorMessage());
					delete res;
					delete db;
					exit(0);
				} 	
			}		

			// Delete all questions:
			db->exec(res, "DELETE from %s WHERE topic_id = %s", MYQUESTION, hidden_id.c_str());
			if (res->status() != DB_COMMAND_OK) {
				fprintf(stdout, "Can't delete question. %s \n\n", db->errorMessage());
				delete res;
				delete db;
				exit(0);
			}
			
			// Delete the topic:
			db->exec(res, "DELETE from %s WHERE topic_id = %s", MYTOPIC, hidden_id.c_str());
                        if (res->status() != DB_COMMAND_OK) {
                                fprintf(stdout, "Can't delete question. %s \n\n", db->errorMessage());
                                delete res;
                                delete db;
                                exit(0);
                        }
		}
		else if(mode == "question")
		{
			// Delete all answers:
			res = db->exec("DELETE from %s WHERE question_id = %s", MYANSWER, hidden_id.c_str());
			if (res->status() != DB_COMMAND_OK) {
				fprintf(stdout, "Can't delete answer number: %s. \n %s \n\n", hidden_id.c_str(), db->errorMessage());
				delete res;
				delete db;
				exit(0);
			}
			
			//Delete question:
			db->exec(res, "DELETE from %s WHERE question_id = %s", MYQUESTION, hidden_id.c_str());
                        if (res->status() != DB_COMMAND_OK) {
                                fprintf(stdout, "Can't delete question. %s \n\n", db->errorMessage());
                                delete res;
                                delete db;
                                exit(0);
                        }
		}
		else if(mode == "answer")
		{
			// Delete all answers:
                        res = db->exec("DELETE from %s WHERE answer_id = %s", MYANSWER, hidden_id.c_str());
                        if (res->status() != DB_COMMAND_OK) {
                                fprintf(stdout, "Can't delete answer. \n %s \n\n", db->errorMessage());
                                delete res;
                                delete db;
                                exit(0);
                        }
		
		}
		cout << h.font("arial", "2")
		<< mode << " deleted.<br><br>\n";
	}
	Pro p; 
	cout << p.back("dbadmin", instance) << endl;
	cout << h._body() << h._html() << endl;

}
