/*
 Copyright (c) 1998 Thomas Linden.

 You have my permission to modify, copy, mutilate, or spindle this code as 
 long as you don't use my name to make money.

 The software comes "as-is" and I cannot make any guarentees that is correct.

 It is distributed under the terms of the GNU General Public License

 Portions of this code was developed by Kelly Black at the University of New Hampshire,
 as these are the routines initPage() and getFormdata(), wich parses the browser
 input. These routines was taken from his cgiClass.h. Thanks to Kelly.         

*/


#include <ctype.h>
#include <string.h>  // some c code here...
#include <sys/types.h>
#include <sys/stat.h>

class cgi {

public:
    // constructor
    cgi(void);

    // start page.  Must be first thing called.
    // If non-null argument given it will load the
    // URL given in string.
    void initPage(char* = NULL);

    // this subroutine is called, if a new cgi object has been initialized
    // it starts the routine getFormdata and converts the resuls (char*) to
    // C++ strings (class string) and stores them in _name[100] and _value[100]
    // I hope 100 is enough...
    void get_all();

    // the data from the form, a string array of 100 entrys    
    string _name[100];
    string _value[100];
    int _num;

    // Environment variables of interest
    string getRefer(void);
    string getAgent(void);
    string getPragma(void);
    string getAccept(void);
    string getPath(void);
    string getPathInfo(void);
    string getPathTranslated(void);
    string getServerSoftware(void);
    string getServerNamer(void);
    string getServerPort(void);
    string getRemoteHost(void);
    string getRemoteAddress(void);
    string getGateway(void);
    string getProtocol(void);
    const char* getRequestMethod(void);
    string getScriptName(void);
    const char* getQueryString(void);
    string getSHLVL(void);
    string getPWD(void);
    string getLogName(void);
    string getUser(void);
    string getHost(void);
    string getHostType(void);

    // Get data from a form.
    // returns number of fields as well as
    // character arrays to the fields.  The
    // first argument returns as the data within the
    // fields and the second argument returns the names
    // of the fields.
    void getFormData(char** &,char** &,int &);
    long getContentLength(void);

    // returns the value of the specified formelement as string
    string get_value(const string& form_name);

    enum Method {
	GET = 0,
	POST = 1
    };

    void turnErrorPrintingOn(void);
    void turnErrorPrintingOff(void);

protected:
private:
    void Error(const char* ,const char* = NULL,const char* = NULL);

    int outputError;

};



// Constructor.  Not much to do here but
// initialize the variables
cgi::cgi(void) {
    outputError = 1;
    get_all();
}


void cgi::get_all()
{
        // converts the fuc... c-strings to c++ STRING's
        int 	f_num=0, x;
        char**	f_val=NULL;
        char**	f_name=NULL;
        getFormData(f_val, f_name, f_num);
        
	_num = f_num;
	
	for(x=0;x<f_num;x++)
	{
		_name[x] = f_name[x];
		_value[x] = f_val[x];
	}
}


string cgi::get_value(const string& form_name)
{
	int c;
	string tmp;
	for(c=0;c<_num;c++)
	{
		if(_name[c] == form_name)
		{
			tmp = _value[c];	
			return tmp;
		}
	}
	return "";
}





void cgi::getFormData(char** &formData,char** &formName,int &numItems) {
    // formData is the information from the form
    // formName is the name of each entry in the form.

    const char* request;
    const char* informationGET;
    char *c;
    char *p;
    char* informationPOST;
    long contentLength;
    char* isGet;
    int i,j,k;
    char hexVal;

    request = getRequestMethod();
    if(request==NULL) {
	formData = NULL;
	formName = NULL;
	numItems = 0;
	return;
    }

    // Check to see how the information was posted.
    // if GET then read in query string.
    // Else read in from stdin.
/*    if(isGet = strstr(request,"GET")) {
	informationGET = getQueryString();
	c = (char *) informationGET;
    }
*/
    isGet = strstr(request,"GET");
    if( strcmp(request,"GET") == 0) {
	informationGET = getQueryString();
	c = (char *) informationGET;
    }  
    else {
	contentLength = getContentLength();
	informationPOST = new char[contentLength+1];
	p = informationPOST;
	for(i=0;i<contentLength;++i)
	    *p++ = getchar();
	*p = '\0';
	c = informationPOST;
    }

    // If no information posted return NULL
    if(c==NULL) {
	numItems = 0;
	formData = NULL;
	formName = NULL;
    }
    else {

	// Figure out how many items by counting the '&'
	numItems = 1;
	for(i=0;i<int(strlen(c));++i) {
	    if(c[i]=='&')
		++numItems;
	}

	// Allocate numItem pointers for the strings
	formData = new char*[numItems];
	formName = new char*[numItems];

	// For each field get the name and the data in the field
	for(j=0;j<numItems;++j) {

	    // Get the name of the field
	    p = c;
	    while((*p != '=')&&(*p++ != '\0'));
	    formName[j] = new char[p-c+2];
	    for(i=0;c<p;++c,++i) {
		switch(*c) {
		case '+':
		    // It's a space
		    formName[j][i] = ' ';
		    break;
		case '%':
		    // It's an escape character
		    hexVal = 0;
		    ++c;
		    for(k=0;(k<2)&&(isxdigit(*c));++k,++c) {
			if(isdigit(*c))
			    hexVal = 16*hexVal + (*c-'0');
			else
			    hexVal = 16*hexVal + (10+toupper(*c)-'A');
		    }
		    --c;
		    formName[j][i] = hexVal;
		    break;
		default:
		    // plain old character
		    formName[j][i] = *c;
		    break;
		}
	    }
	    formName[j][i] = '\0';

	    // Get the information in the field
	    ++c;
	    ++p;
	    while((*p != '&')&&(*p++ != '\0'));
	    formData[j] = new char[p-c+2];
	    for(i=0;c<p;++c,++i) {
		switch(*c) {
		case '+':
		    // It's a space
		    formData[j][i] = ' ';
		    break;
		case '%':
		    // It's an escape character
		    hexVal = 0;
		    ++c;
		    for(k=0;(k<2)&&(isxdigit(*c));++k,++c) {
			if(isdigit(*c))
			    hexVal = 16*hexVal + (*c-'0');
			else
			    hexVal = 16*hexVal + (10+toupper(*c)-'A');
		    }
		    --c;
		    formData[j][i] = hexVal;
		    break;
		default:
		    // plain old character
		    formData[j][i] = *c;
		    break;
		}
	    }
	    formData[j][i] = '\0';

	    ++c;
	}

    }

    if(isGet==NULL) 
	delete [] informationPOST;

}




void cgi::turnErrorPrintingOn(void) {
    outputError = 1;
}

void cgi::turnErrorPrintingOff(void){
    outputError = 0;
}




// Start of the web page.
// if passed a null pointer then assume that the
// following text is html, otherwise treat it as
// a link to another page.
void cgi::initPage(char* location) {

    if(location==NULL) 
	cout << "Content-type:text/html\n\n";
    else
	cout << "Location:http:" << location << endl << endl;
    
}





//Get the desired environment variable

string cgi::getRefer(void) {
return(getenv("HTTP_REFERER"));
}


string cgi::getAgent(void){
return(getenv("HTTP_USER_AGENT"));
}


string cgi::getPragma(void){
return(getenv("HTTP_PRAGMA"));
}


string cgi::getAccept(void){
return(getenv("HTTP_ACCEPT"));
}


string cgi::getPath(void){
return(getenv("PATH"));
}

string cgi::getPathInfo(void){
return(getenv("PATH_INFO"));
}

string cgi::getPathTranslated(void){
return(getenv("PATH_TRANSLATED"));
}


string cgi::getServerSoftware(void){
return(getenv("SERVER_SOFTWARE"));
}


string cgi::getServerNamer(void){
return(getenv("SERVER_NAME"));
}


string cgi::getServerPort(void){
return(getenv("SERVER_PORT"));
}


string cgi::getRemoteHost(void){
return(getenv("REMOTE_HOST"));
}


string cgi::getRemoteAddress(void){
return(getenv("REMOTE_ADDR"));
}


string cgi::getGateway(void){
return(getenv("GATEWAY_INTERFACE"));
}


string cgi::getProtocol(void){
return(getenv("SERVER_PROTOCOL"));
}


const char* cgi::getRequestMethod(void){
return(getenv("REQUEST_METHOD"));
}


string cgi::getScriptName(void){
return(getenv("SCRIPT_NAME"));
}


const char* cgi::getQueryString(void){
return(getenv("QUERY_STRING"));
}


string cgi::getSHLVL(void){
return(getenv("SHLVL"));
}


string cgi::getPWD(void){
return(getenv("PWD"));
}


string cgi::getLogName(void){
return(getenv("LOGNAME"));
}


string cgi::getUser(void){
return(getenv("USER"));
}


string cgi::getHost(void){
return(getenv("HOST"));
}


string cgi::getHostType(void){
return(getenv("HOSTTYPE"));
}


long cgi::getContentLength(void) {
    long length;
    const char* content;
    const char *c;
    
    content = getenv("CONTENT_LENGTH");
    length = 0;

    if(content==NULL)
	return(0);

    for(c = content;*c != '\0';)
	length = 10*length + ((long)(*c++-'0'));

    return(length);

}

