

#include <stdlib.h>
#include <string.h>
#include "util.h"

void
parse_proxy_env(char **proxy_name, int *proxy_port)
{
 char *proxy_env;
 char *host_c_port;
 int len;

 if ( *proxy_name )
	 free(*proxy_name);
 *proxy_name = NULL;
 *proxy_port = 0;
 proxy_env = getenv("http_proxy");
 if (!proxy_env) {
	 return;
 }
 char *pos = strstr(proxy_env, "http:");
 if (!pos)
	 return;
 char *pos2 = strstr(proxy_env, "//");
 if (!pos) 
	 host_c_port = strdup(pos+5);
 else 
	 host_c_port = strdup(pos2+2);
  
 /* now host_c_port contains a string like "host:port" */
 char *pt = host_c_port;
 len = strlen(pt);
 while (*pt!=':' && *pt) pt++;
 *pt = '\0';
 if ( (pt - host_c_port) == len ) { 
	 *proxy_port = 0;       
	 /* so we don't crash if the string wasn't host:port */
	 free(host_c_port);
	 return;
 }
 pt++; 
 *proxy_port = atoi(pt);
 *proxy_name = strdup(host_c_port);
  
 free(host_c_port);
}

void 
get_proxy_name(char *str, char **proxy_name, int *proxy_port)
{
 int len;
 if (*proxy_name)
	 free(*proxy_name);
 char *pt;
 pt = *proxy_name = str;
 len = strlen(pt);
 while (*pt!=':' && *pt) pt++;
 *pt = '\0';
 if ( (pt - *proxy_name) == len ) {
	 *proxy_port = 0;
	 return;
 }
 pt++;
 *proxy_port = atoi(pt);
}
