/* This for emacs -*- linux-c -*- */

#include "log.h"
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <time.h>
#include <unistd.h>
#include "ssplit.h"
#include <string.h>


/* Yes, all these functions are nearly equal.... but I felt that a little  */
/* cut & paste wouldn't be so bad after all. */


#define ERRORSTR  "%s asNews[%d] ERROR: "
#define MSGSTR "%s asNews[%d]: " 
#define TIMESTR "%c"



static int mode = 0; /* 1 for syslog-like, 0 for plain format */

void 
log_mode ( int m )
{
 mode = m;
}


void
log_error(const char *fmt, ...)
{
 va_list ap;
 char timestr[64];
 struct tm *ltime;
 time_t t;
 
 t = time(NULL);
 ltime = localtime(&t);
 strftime(timestr, 63, TIMESTR, ltime);
 va_start(ap, fmt);
 fflush ( stderr );
 if (mode) fprintf ( stderr, ERRORSTR, timestr, getpid() );
 vfprintf( stderr, fmt, ap);
 fprintf( stderr, "\n");
 fflush ( stderr );
 va_end(ap);

}


void
log_msg(const char *fmt, ...)
{
 va_list ap;
 char timestr[64];
 struct tm *ltime;
 time_t t;
 
 t = time(NULL);
 ltime = localtime(&t);

 strftime(timestr, 63,  TIMESTR, ltime);
 va_start(ap, fmt);
 fflush ( stdout );
 if (mode) fprintf ( stdout, MSGSTR, timestr, getpid() );
 vfprintf( stdout, fmt, ap);
 fprintf ( stdout, "\n");
 fflush ( stdout );
 va_end(ap);
}




void
log_error_nonl(const char *fmt, ...)
{
 va_list ap;
 char timestr[64];
 struct tm *ltime;
 time_t t;
 
 t = time(NULL);
 ltime = localtime(&t);
 strftime(timestr, 63,  TIMESTR, ltime);
 va_start(ap, fmt);
 fflush ( stderr );
 if (mode) fprintf ( stderr, ERRORSTR, timestr, getpid() );
 vfprintf( stderr, fmt, ap);
 fflush ( stderr );
 va_end(ap);

}


void
log_msg_nonl(const char *fmt, ...)
{
 va_list ap;
 char timestr[64];
 struct tm *ltime;
 time_t t;
 
 t = time(NULL);
 ltime = localtime(&t);

 strftime(timestr, 63,  TIMESTR, ltime);
 va_start(ap, fmt);
 fflush ( stdout );
 if (mode) fprintf ( stdout, MSGSTR, timestr, getpid() );
 vfprintf( stdout, fmt, ap);
 fflush ( stdout );
 va_end(ap);
}


void
log_error_long(const char *fmt, ...)
{
 va_list ap;
 char timestr[64];
 struct tm *ltime;
 time_t t;
 char *pt;
 int nlines = 0;
 char *buf;
 int i;
 char **lines;

 if (!mode) {
	 va_start(ap, fmt);
	 vfprintf ( stderr, fmt, ap );
	 fprintf ( stderr, "\n");
	 fflush(stderr);
	 va_end(ap);
	 return;
 }
 
 t = time(NULL);
 ltime = localtime(&t);

 strftime(timestr, 63,  TIMESTR, ltime);
 va_start(ap, fmt);

 if ( vasprintf ( &buf, fmt, ap ) == 0 )
	 return;

 for ( pt = buf; *pt; pt++)
	 if ( *pt == '\n' ) nlines++;
 lines = (char **) malloc ( (nlines+1)*sizeof(char *) );
 
 nlines = ssplit ( buf, "\n", lines, nlines+1, 1, 1);
 
 for (i=0; i<nlines; i++) 
	 fprintf ( stderr, ERRORSTR "%s\n", 
		   timestr, getpid(), lines[i]);
 fflush ( stderr );
 free(lines);
 free(buf);

 va_end(ap);
}



void
log_msg_long(const char *fmt, ...)
{
 va_list ap;
 char timestr[64];
 struct tm *ltime;
 time_t t;
 char *pt;
 int nlines = 0;
 char *buf;
 int i;
 char **lines;

  if (!mode) {
	 va_start(ap, fmt);
	 vfprintf ( stdout, fmt, ap );
	 fprintf ( stdout, "\n");
	 fflush(stdout);
	 va_end(ap);
	 return;
 }

 t = time(NULL);
 ltime = localtime(&t);

 strftime(timestr, 63,  TIMESTR, ltime);
 va_start(ap, fmt);

 if ( vasprintf ( &buf, fmt, ap ) == 0 )
	 return;

 for ( pt = buf; *pt; pt++)
	 if ( *pt == '\n' ) nlines++;
 lines = (char **) malloc ( (nlines+1)*sizeof(char *) );

 fflush ( stdout );
 nlines = ssplit ( buf, "\n", lines, nlines+1, 1, 1);

 for (i=0; i<nlines; i++) 
	 fprintf ( stdout, MSGSTR "%s\n", 
		   timestr, getpid(), lines[i]);

 fflush ( stdout );
 free(buf);
 free(lines);
 va_end(ap);
}


