/* 
 *  Copyright (C) 1999 Maurice Fernndez
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifdef HAVE_CONFIG_H
#    include <config.h>
#endif
#ifdef WITH_DMALLOC
#    include <dmalloc.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gui_sig.h"
#include "gui.h"
#include "NewsList.h"

GtkWidget *main_window;
GtkWidget *main_vbox;
GtkWidget *main_frame;
GtkWidget *scrolled_window;
GtkWidget *news_list;
GtkWidget *statusbar1;
int statusbar_id;


static guint update_statusbar ( GtkWidget *widget, 
				GdkEvent *event, gpointer data );
/*
GtkWidget*
get_widget                             (GtkWidget       *widget,
                                        gchar           *widget_name)
{
  GtkWidget *found_widget;

  if (widget->parent)
    widget = gtk_widget_get_toplevel (widget);
  found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget),
                                                   widget_name);
  if (!found_widget)
    g_warning ("Widget not found: %s", widget_name);
  return found_widget;
}
*/

/* This is an internally used function to set notebook tab widgets. */
/*
void
set_notebook_tab                       (GtkWidget       *notebook,
                                        gint             page_num,
                                        GtkWidget       *widget)
{
  GtkNotebookPage *page;
  GtkWidget *notebook_page;

  page = (GtkNotebookPage*) g_list_nth (GTK_NOTEBOOK (notebook)->children, page_num)->data;
  notebook_page = page->child;
  gtk_widget_ref (notebook_page);
  gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), page_num);
  gtk_notebook_insert_page (GTK_NOTEBOOK (notebook), notebook_page,
                            widget, page_num);
  gtk_widget_unref (notebook_page);
}

*/

GtkWidget*
create_main_window (char *title)
{

  main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (main_window), "main_window", main_window);
  gtk_container_border_width (GTK_CONTAINER (main_window), 2);
  gtk_signal_connect (GTK_OBJECT (main_window), "delete_event",
                      GTK_SIGNAL_FUNC (on_main_window_delete_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (main_window), "destroy",
                      GTK_SIGNAL_FUNC (on_main_window_destroy),
                      NULL);
  gtk_window_set_title (GTK_WINDOW (main_window), "asNews " VERSION );
  gtk_window_set_policy (GTK_WINDOW (main_window), TRUE, TRUE, FALSE);

  main_vbox = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (main_window), "main_vbox", main_vbox);
  gtk_widget_show (main_vbox);
  gtk_container_add (GTK_CONTAINER (main_window), main_vbox);
  gtk_container_border_width (GTK_CONTAINER (main_vbox), 2);

  main_frame = gtk_frame_new ( title );
  gtk_object_set_data (GTK_OBJECT (main_window), "main_frame", main_frame);
  gtk_widget_show (main_frame);
  gtk_box_pack_start (GTK_BOX (main_vbox), main_frame, TRUE, TRUE, 0);

  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (main_window), "scrolled_window", scrolled_window);
  gtk_widget_show (scrolled_window);
  gtk_container_add (GTK_CONTAINER (main_frame), scrolled_window);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  news_list = gtk_list_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "news_list", news_list);
  gtk_widget_show (news_list);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(scrolled_window), news_list);

  statusbar1 = gtk_statusbar_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "statusbar1", statusbar1);
  gtk_widget_show (statusbar1);
  gtk_box_pack_start (GTK_BOX (main_vbox), statusbar1, FALSE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (statusbar1), 2);

  statusbar_id = gtk_statusbar_get_context_id ( GTK_STATUSBAR(statusbar1),
						"The URL of the News Item");

  return main_window;
}


void 
display_news_list ( NewsList *list ) 
{  
  GtkWidget *list_item;
  GtkTooltips *tooltips;
  int len = 0;
  
  for ( Item *ite = list->get_first(); ite!= NULL; ite=list->get_next() ) {
	  int nlen = strlen(ite->get_field("link"));
	  if (nlen > len)
		  len = nlen;
  }
  char str[(int)(len * 1.7) + 1];
  char *pt = str;
  for ( int i=0; i < (int)(len * 1.7); i++)  
	  *pt++ = ' ';
  *pt = '\0';

  gtk_statusbar_push ( GTK_STATUSBAR(statusbar1), 
		       statusbar_id, str );

  for ( Item *it = list->get_first(); it!= NULL; it=list->get_next() ) {
    list_item = gtk_list_item_new_with_label ( it->get_field("title") );
   
    tooltips = gtk_tooltips_new();
    gtk_container_add ( GTK_CONTAINER(news_list), list_item );
    gtk_widget_show ( list_item );
   
    gtk_tooltips_set_tip ( GTK_TOOLTIPS(tooltips), list_item, 
			   it->get_field("link"), it->get_field("title"));
    
    gtk_signal_connect(GTK_OBJECT(list_item), 
		       "button_press_event",
		       GTK_SIGNAL_FUNC(update_statusbar), 
		       it->get_field("cdate"));
  
  }  

}



guint
update_statusbar ( GtkWidget *widget, 
		   GdkEvent *event, gpointer data )
{
 GdkEventKey *ek;
 if ( event->type == GDK_BUTTON_PRESS )
	 gtk_statusbar_push ( GTK_STATUSBAR(statusbar1), 
			      statusbar_id, (char *)data );  
 else if (event->type == GDK_KEY_PRESS) {
	 ek = (GdkEventKey *)event;
	 if (ek->keyval == GDK_Return )
		 gtk_statusbar_push ( GTK_STATUSBAR(statusbar1), 
				      statusbar_id, (char *)data );  
 }

 
 return 1;
}
