
#include "dotfile.h"
#include <stdlib.h>
#include <unistd.h>



void 
displayTask( gpointer key, gpointer value, gpointer data)
{
 FILE *fp = (FILE *)data;
 Item *it = (Item *)value;

 fprintf( fp, "Dumping task %s\n", (char *)key);
 it->print(stdout);
 printf("\n");
 

}

void
displayDMethod ( gpointer key, gpointer value, gpointer data )
{
 char *Modes[] = { "network", "file", "proxy" };

 DMethod *m = (DMethod *)value;
 fprintf ( (FILE *)data, "Method %s\t\ttype %s.\n",
	   (char *)key, Modes[m->downmode] );

}

int main(int argc, char *argv[])
{
 DotFile *dfile;

 dfile = read_dotfile(NULL);

 GenericHash *dmethods = dfile->dmethods;
 GenericHash *tasks = dfile->tasks;
 Item *config = dfile->config;
 
 printf ("\nTesting download methods section parsing\n");
 dmethods->foreach ( displayDMethod, stdout );
 
 printf ("\nTesting tasks section parsing\n");

 tasks->foreach ( displayTask, stdout);

 printf ("\nTesting config section parsing\n");
 config->print(stdout);

}

