/*************************************************************************
    asNews --- retrieves news from the net and shows it in your desktop
    Copyright (C) 1998-1999 Mauricio Julio Fernndez Pradier

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*************************************************************************/


#include "RSSParser.h"
#include "Item.h"
#include "NewsList.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "parser.h"


typedef struct news_item {
	unsigned char *title;
	unsigned char *link;
} *itemPtr, item;

typedef struct popo {
	int num;
	itemPtr items[127];
} *newsPtr, newsl;

static itemPtr parseItem(xmlDocPtr doc, xmlNodePtr cur);
static NewsList *parse_from_mem(char *pt);

itemPtr
parseItem(xmlDocPtr doc, xmlNodePtr cur) 
{
 itemPtr ret = NULL;

 ret = (itemPtr) malloc(sizeof(item));
 if (ret == NULL) {
	 return(NULL);
 }
 memset(ret, 0, sizeof(item));

 cur = cur->childs;

 while (cur != NULL) {
	 if ( !strcmp((char *)cur->name, "title") ) 
		 ret->title = xmlNodeListGetString ( doc, cur->childs, 1);
	 if ( !strcmp((char *)cur->name, "link") ) 
		 ret->link = xmlNodeListGetString ( doc, cur->childs, 1);
	 cur = cur->next;
 }

 return ret;
}

NewsList *
parse_from_mem(char *pt)
{
 xmlDocPtr doc;
 newsPtr ret;
 itemPtr it;
 /*xmlNsPtr ns;*/
 xmlNodePtr cur;

 doc = xmlParseMemory( pt, strlen(pt) );
 if ( doc == NULL ) return NULL;

 cur = doc->root;
 if (cur == NULL) {
	 xmlFreeDoc(doc);
	 return(NULL);
 }

 if (strcasecmp((char *)cur->name, "rss")) {
	 xmlFreeDoc(doc);
	 return(NULL);
 }
 
 ret = (newsPtr) malloc(sizeof(newsl));
 if (ret == NULL) {
	 xmlFreeDoc(doc);
	 return(NULL);
 }
 memset(ret, 0, sizeof(newsl));

 /* second level: channel */
 cur = cur->childs;
 if ( cur == NULL) {
	 xmlFreeDoc(doc);
	 return NULL;
 }
 /* third level: mixed things plus list of items */
 cur = cur->childs;

 while (cur != NULL) {
	 if (!strcmp((char *)cur->name, "item")) {
		 it = parseItem(doc, cur);
		 if (it != NULL)
			 ret->items[ret->num++] = it;
		 if (ret->num >= 127) break;
	 }
	 cur = cur->next;
 }

 NewsList *nl = new NewsList();

 for (int i=0; i<ret->num; i++) {
	 if (!ret->items[i]) continue;
	 Item _it;
	 _it.insert_field("title", (char *)ret->items[i]->title);
	 _it.insert_field("link", (char *)ret->items[i]->link);
	 _it.insert_field("cdate", "UNKNOWN");
	 nl->insert ( &_it );
	 /* the strings pointed to inside ret->items[i] are free'd when doing
	    xmlFreeDoc(doc) 
	 */
	 free ( ret->items[i] );
 }

 xmlFreeDoc(doc);
 free(ret);
 return nl;

}


NewsList *
RssParser::build_list()
{
 if (retr == NULL)
         return new NewsList();
  
 if (retr->retrieve() != 0)
         return new NewsList();
  
 char *pt = retr->get_data();

 NewsList *n = parse_from_mem( pt );

 return n;
}
