
#ifndef __NEWSTICKER_H__

#define __NEWSTICKER_H__

#include <gtk/gtk.h>
#include <glib.h>
#include <string.h>
#include "Item.h"
#include "NewsList.h"

class NewsTicker {
 
 public:
 NewsTicker(char *name) { }
 /* create and try to display "name" news */
 virtual ~NewsTicker() { } 

};


class PageNode: public Cloneable {
  GtkWidget *page;
  int num;
  char *name;
 public:
  PageNode(char *name, GtkWidget *page, int num);
  PageNode(const PageNode &ob);
  PageNode(const PageNode *ob);
  void destroy();
  Cloneable *clone();

  char *get_name() { return name; }
  GtkWidget *get_widget() { return page; }
};


class NewsPage {
  friend gint  select_row_callback(GtkWidget *, 
				  GdkEventButton *, 
				  gpointer); 
 protected:
   char *selected_URL;
  GtkWidget *scrolled_window;
  GtkWidget *news_list;
  GtkWidget *URL_label;
  GtkWidget *main_label;
  GtkWidget *date_label;
  GtkWidget *title_label;
 public:
  NewsPage(char *);
  GtkWidget *get_widget();
  GtkWidget *get_label();
};

class ModifiablePage: public NewsPage  {
  int row_num;
  ModifiablePage(const ModifiablePage &) : NewsPage(NULL) {  }
  /* copy constructor private so it is not used by accident */
 public:
  ModifiablePage(char *p): NewsPage(p) { 
	  row_num = 0;
  }
  int add_news(NewsList *);
  ~ModifiablePage();
};

class NewsNoteBook {
 GtkWidget *notebook1;
 GenericHash *page_list;

 int numpages;
 
 public:
  int add_page(char *name);
 int add_page(NewsPage *page);
 int del_page(char *name);
 int del_page(NewsPage *page);
 NewsNoteBook();
 GtkWidget *get_widget();
 ~NewsNoteBook();
};

class GTickerWindow {
 NewsNoteBook *nbook;

 GtkWidget *main_window;
 GtkWidget *main_vbox;
 GtkWidget *menu_handlebox;
 GtkWidget *menubar;
 GtkWidget *File;
 GtkWidget *menu3;
 GtkWidget *Preferences;
 GtkWidget *Save_preferences;
 GtkWidget *Quit;
 GtkWidget *Help;
 GtkWidget *menu4;
 GtkWidget *About;
 GtkWidget *License;
 GtkWidget *icons_handlebox;
 GtkWidget *toolbar_hbox;
 GtkWidget *toolbar;
 GtkWidget *news_server_selector;
 GtkWidget *main_frame;
 GtkWidget *statusbar1;
 GtkWidget *update_button;

 public:
 GTickerWindow();
 ~GTickerWindow();
 NewsNoteBook *get_notebook() { return nbook; }
 GtkWidget *get_widget() { return main_window; } 
 friend gint on_combo_change_selection (GtkWidget *w, 
					GdkEventKey *event, 
					gpointer data);
 friend void fetch_news ( gpointer data );
};

class GNewsTicker: protected NewsTicker {

 GTickerWindow *twindow;
 public:
 GNewsTicker(char *name);
 GTickerWindow *get_window() { return twindow; }
 GtkWidget *get_widget() { return twindow->get_widget(); }
 ~GNewsTicker();

};

#endif
