#include "config.h"
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "NewsTicker.h"
#include "Item.h"
#include "NewsList.h"
#include "Downloader.h"
#include "NewsParsers.h"
#include "license.h"
#include "BusyDialog.h"
#include "gtk_helper.h"
#include "BrowseMenu.h"
#include "fetch.xpm"

static gboolean
on_main_window_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data);

static gboolean
on_main_window_destroy_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data);

static void
on_Preferences_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

static void
on_Save_preferences_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

static void
on_Quit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data);
/*
static void
on_About_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data);
*/

static void
on_update_button_clicked                (GtkWidget     *menuitem,
					 gpointer         data);


PageNode::PageNode(char *name, GtkWidget *page, int num)
{ 
  this->page = page; 
  this->name = strdup(name); 
  this->num = num;
}


PageNode::PageNode(const PageNode &ob) 
{
  this->page = ob.page; 
  this->name = strdup(ob.name);
  this->num = ob.num;
}

PageNode::PageNode(const PageNode *ob) 
{
  this->page = ob->page; 
  this->name = strdup(ob->name);
  this->num = ob->num;
}


void 
PageNode::destroy() {
  free(name);
}


Cloneable *
PageNode::clone() { 
  return new PageNode(this); 
}




GNewsTicker::GNewsTicker(char *name) : NewsTicker(name)
{
 twindow = new GTickerWindow();
}


GNewsTicker::~GNewsTicker() 
{
 if (twindow) 
	 delete twindow;
}


NewsNoteBook::NewsNoteBook()
{
  notebook1 = gtk_notebook_new ();
  
  page_list = new GenericHash();
 /*
  NewsPage *np; 
  np = new NewsPage("Main");
  add_page(np); 
 */
}

NewsNoteBook::~NewsNoteBook()
{
  delete page_list;
  gtk_widget_destroy ( GTK_WIDGET ( notebook1 ) );

}

GtkWidget *
NewsNoteBook::get_widget()
{
 return notebook1;
}


int
NewsNoteBook::add_page(char *name)
{
  NewsPage *np;
  np = new NewsPage(name);
  return add_page(np);
}

int 
NewsNoteBook::add_page(NewsPage *np)
{
 gtk_notebook_append_page(GTK_NOTEBOOK(notebook1), np->get_widget(), 
			  np->get_label());
 
 numpages++;
 return 0;
}


int 
NewsNoteBook::del_page(NewsPage *p)
{
 GList *l;
 GtkWidget *w;
 int i;
 
 w = p->get_widget();
 i = 0;
 for (l = GTK_NOTEBOOK(notebook1)->children; l; l=l->next) {
	 if ( l->data == w ) { /* that's the widget we want to remove */
		 gtk_notebook_remove_page(GTK_NOTEBOOK(notebook1), i);
		 return 0;
	 }
	 i++;
 }

 return -1;  /* not found */
}

int 
NewsNoteBook::del_page(char *name)
{
  NewsPage *p;
  
  p = (NewsPage *)page_list->get_field(name);
  if (!p) 
	  return -1;
  
  return del_page(p);
}



NewsPage::NewsPage(char *label)
{

  selected_URL = "http://www.geocities.com/"
	         "SiliconValley/Vista/2075/new/asNews.html";
	
  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolled_window);
  
  gtk_container_border_width (GTK_CONTAINER (scrolled_window), 2);

  news_list = gtk_clist_new (3);
  gtk_clist_set_selection_mode (GTK_CLIST (news_list), GTK_SELECTION_BROWSE);
  gtk_signal_connect_after(GTK_OBJECT(news_list),
			   "button_press_event",
			   GTK_SIGNAL_FUNC(select_row_callback),
			   this);

  gtk_widget_show (news_list);
  gtk_container_add (GTK_CONTAINER (scrolled_window), news_list);
  gtk_container_border_width (GTK_CONTAINER (news_list), 2);
  gtk_clist_set_column_width (GTK_CLIST (news_list), 0, 210);
  gtk_clist_set_column_width (GTK_CLIST (news_list), 2, 200);
  gtk_clist_set_column_width (GTK_CLIST (news_list), 1, 150);
  gtk_clist_column_titles_show (GTK_CLIST (news_list));
  
  title_label = gtk_label_new ("Title");
  gtk_widget_show (title_label);
  gtk_clist_set_column_widget (GTK_CLIST (news_list), 0, title_label);
  
  URL_label = gtk_label_new ("URL");
  gtk_widget_show (URL_label);
  gtk_clist_set_column_widget (GTK_CLIST (news_list), 2, URL_label);
  
  date_label = gtk_label_new ("Date");
  gtk_widget_show (date_label);
  gtk_clist_set_column_widget (GTK_CLIST (news_list), 1, date_label);
 
  main_label = gtk_label_new (label);
  gtk_widget_show (main_label);
}

GtkWidget *
NewsPage::get_widget()
{
  return scrolled_window;
}

GtkWidget *
NewsPage::get_label()
{
  return main_label;
}


int
ModifiablePage::add_news(NewsList *l)
{
  Item *it;
  char *row[3];
  char *p;

  if (!l) return -1;
  gtk_clist_freeze( GTK_CLIST(news_list) );
  for (it = l->get_first(); it; it = l->get_next()) {
    row[0] = it->get_field("title");
    row[1] = (p=it->get_field("cdate"))?p:"Unknown date.";
    row[2] = it->get_field("link");
    gtk_clist_insert( GTK_CLIST(news_list), row_num, row);
    gtk_clist_set_row_data ( GTK_CLIST(news_list), row_num++, strdup(row[2])); 
    
  }
  gtk_clist_thaw ( GTK_CLIST(news_list));
  return 0;
}


ModifiablePage::~ModifiablePage()
{
 for(int i=0; i<row_num; i++)
	 free ( gtk_clist_get_row_data ( GTK_CLIST(news_list), i ) );

}



gint
select_row_callback(GtkWidget *widget,
			 GdkEventButton *event,
			 gpointer data)
{
   /* check which button is pressed */
 if (event != NULL) 
	 if (event->button == 3) {
		 char *url;
		 int row;
		 int column;
		 
		 gtk_clist_get_selection_info ( GTK_CLIST(widget), 
						(int)event->x, (int)event->y,
						&row, &column );
		 url = (char *)gtk_clist_get_row_data ( GTK_CLIST(widget), 
							row );
		 NewsPage *mp = (NewsPage *)data;
		 mp->selected_URL = url;
	 	 
		 BrowseMenu *br = new BrowseMenu(url);
		 GtkWidget *menu = br->get_widget();
		 gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL,
				 NULL, 3, event->time);
		 
	 }
 
 
 return (TRUE);
}



GTickerWindow::GTickerWindow()
{
 nbook = NULL;

 
  main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (main_window), "main_window", main_window);
  gtk_container_border_width (GTK_CONTAINER (main_window), 2);
  gtk_signal_connect (GTK_OBJECT (main_window), "delete_event",
                      GTK_SIGNAL_FUNC (on_main_window_delete_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (main_window), "destroy_event",
                      GTK_SIGNAL_FUNC (on_main_window_destroy_event),
                      NULL);
  gtk_window_set_title (GTK_WINDOW (main_window), PACKAGE " --- " VERSION);
  gtk_window_set_policy (GTK_WINDOW (main_window), TRUE, TRUE, FALSE);

  main_vbox = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (main_window), "main_vbox", main_vbox);
  gtk_widget_show (main_vbox);
  gtk_container_add (GTK_CONTAINER (main_window), main_vbox);
  gtk_container_border_width (GTK_CONTAINER (main_vbox), 2);

  menu_handlebox = gtk_handle_box_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "menu_handlebox", menu_handlebox);
  gtk_widget_show (menu_handlebox);
  gtk_box_pack_start (GTK_BOX (main_vbox), menu_handlebox, FALSE, FALSE, 0);

  menubar = gtk_menu_bar_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "menubar", menubar);
  gtk_widget_show (menubar);
  gtk_container_add (GTK_CONTAINER (menu_handlebox), menubar);
  gtk_container_border_width (GTK_CONTAINER (menubar), 1);

  File = gtk_menu_item_new_with_label ("File");
  gtk_object_set_data (GTK_OBJECT (main_window), "File", File);
  gtk_widget_show (File);
  gtk_container_add (GTK_CONTAINER (menubar), File);

  menu3 = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "menu3", menu3);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (File), menu3);

  Preferences = gtk_menu_item_new_with_label ("Preferences");
  gtk_object_set_data (GTK_OBJECT (main_window), "Preferences", Preferences);
  gtk_widget_show (Preferences);
 /* gtk_container_add (GTK_CONTAINER (menu3), Preferences);*/
  gtk_signal_connect (GTK_OBJECT (Preferences), "activate",
                      GTK_SIGNAL_FUNC (on_Preferences_activate),
                      NULL);

  Save_preferences = gtk_menu_item_new_with_label ("Save preferences");
  gtk_object_set_data (GTK_OBJECT (main_window), "Save_preferences", Save_preferences);
  gtk_widget_show (Save_preferences);
/*  gtk_container_add (GTK_CONTAINER (menu3), Save_preferences);*/
  gtk_signal_connect (GTK_OBJECT (Save_preferences), "activate",
                      GTK_SIGNAL_FUNC (on_Save_preferences_activate),
                      NULL);

  Quit = gtk_menu_item_new_with_label ("Quit");
  gtk_object_set_data (GTK_OBJECT (main_window), "Quit", Quit);
  gtk_widget_show (Quit);
  gtk_container_add (GTK_CONTAINER (menu3), Quit);
  gtk_signal_connect (GTK_OBJECT (Quit), "activate",
                      GTK_SIGNAL_FUNC (on_Quit_activate),
                      NULL);

  Help = gtk_menu_item_new_with_label ("Help");
  gtk_object_set_data (GTK_OBJECT (main_window), "Help", Help);
  gtk_widget_show (Help);
  gtk_container_add (GTK_CONTAINER (menubar), Help);
  gtk_menu_item_right_justify (GTK_MENU_ITEM (Help));

  menu4 = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "menu4", menu4);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (Help), menu4);

  License = gtk_menu_item_new_with_label ("License");
  gtk_object_set_data (GTK_OBJECT (main_window), "License", License);
  gtk_widget_show (License);
  gtk_container_add (GTK_CONTAINER (menu4), License);
  gtk_signal_connect (GTK_OBJECT (License), "activate",
                      GTK_SIGNAL_FUNC (menu_help_license_activate),
                      NULL);
  /*
  About = gtk_menu_item_new_with_label ("About");
  gtk_object_set_data (GTK_OBJECT (main_window), "About", About);
  gtk_widget_show (About);
  gtk_container_add (GTK_CONTAINER (menu4), About);
  gtk_signal_connect (GTK_OBJECT (About), "activate",
                      GTK_SIGNAL_FUNC (on_About_activate),
                      NULL);
  */

  icons_handlebox = gtk_handle_box_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "icons_handlebox", icons_handlebox);
  gtk_widget_show (icons_handlebox);
  gtk_box_pack_start (GTK_BOX (main_vbox), icons_handlebox, FALSE, FALSE, 0);

  toolbar_hbox = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (main_window), "toolbar_hbox", toolbar_hbox);
  gtk_widget_show (toolbar_hbox);
  gtk_container_add (GTK_CONTAINER (icons_handlebox), toolbar_hbox);
  gtk_container_border_width (GTK_CONTAINER (toolbar_hbox), 1);

  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_object_set_data (GTK_OBJECT (main_window), "toolbar", toolbar);
  gtk_widget_show (toolbar);
  gtk_box_pack_start (GTK_BOX (toolbar_hbox), toolbar, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (toolbar), 2);

  {
	  GtkWidget *pixmapwid;
	  GdkPixmap *pixmap;
	  GdkBitmap *mask;
	  GtkStyle *style;

	  style = gtk_widget_get_style(main_window);
	  gtk_widget_realize(main_window);
	  /* Now on to the xpm stuff */
	  pixmap = gdk_pixmap_create_from_xpm_d (main_window->window, &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       fetch_xpm);
	  pixmapwid = gtk_pixmap_new (pixmap, mask);
	  
	  update_button = gtk_button_new ();
	  /* Pack the pixmap and label into the box */
	  gtk_container_add (GTK_CONTAINER (update_button),
			      pixmapwid);
    
	  gtk_widget_show(pixmapwid);
  }
  gtk_widget_show ( update_button );
  gtk_box_pack_start (GTK_BOX (toolbar_hbox), update_button, FALSE, TRUE, 0);
  /* Connect the "clicked" signal of the button to our callback */
  gtk_signal_connect (GTK_OBJECT (update_button), "clicked",
		      GTK_SIGNAL_FUNC (on_update_button_clicked), this);


  news_server_selector = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "news_server_selector", news_server_selector);
  gtk_widget_show (news_server_selector);
  gtk_box_pack_start (GTK_BOX (toolbar_hbox), news_server_selector, FALSE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (news_server_selector), 5);

  GList *slist = get_servers_list();
  gtk_combo_set_popdown_strings( GTK_COMBO(news_server_selector), slist) ;
  gtk_entry_set_editable ( GTK_ENTRY(GTK_COMBO(news_server_selector)->entry),
			   FALSE);

  gtk_signal_connect(GTK_OBJECT(GTK_COMBO(news_server_selector)->entry), 
		     "key_press_event",
		     GTK_SIGNAL_FUNC (on_combo_change_selection), this);  
  
  GtkTooltips *tt = gtk_tooltips_new();
  gtk_tooltips_set_tip ( tt, news_server_selector, 
			 "Press ENTER to download selected news.", NULL );
  
  main_frame = gtk_frame_new ("Latest News");
  gtk_object_set_data (GTK_OBJECT (main_window), "main_frame", main_frame);
  gtk_widget_show (main_frame);
  gtk_box_pack_start (GTK_BOX (main_vbox), main_frame, TRUE, TRUE, 5);


  GtkWidget *notebook1;

  nbook = new NewsNoteBook();
  notebook1 = nbook->get_widget();

  gtk_container_add (GTK_CONTAINER (main_frame), notebook1);
  gtk_widget_show (notebook1);
    
  statusbar1 = gtk_statusbar_new ();
  gtk_object_set_data (GTK_OBJECT (main_window), "statusbar1", statusbar1);
  gtk_widget_show (statusbar1);
  gtk_box_pack_start (GTK_BOX (main_vbox), statusbar1, FALSE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (statusbar1), 2);

}

GTickerWindow::~GTickerWindow()
{
 if (nbook) delete nbook;
 gtk_widget_destroy( GTK_WIDGET(main_window));

}



/*
  SIGNAL FUNCS

*/


void
on_update_button_clicked                (GtkWidget     *menuitem,
					 gpointer         data)
{
 fetch_news ( data );

}

void 
fetch_news ( gpointer data )
{
 GTickerWindow *tw = (GTickerWindow *)data;
 GtkEntry *e = GTK_ENTRY(GTK_COMBO(tw->news_server_selector)->entry);

 Mode mode;
 mode = find_Mode ( gtk_entry_get_text ( GTK_ENTRY(e) ) );
 if ( mode == -1 ) 
	 return;

 delete tw->nbook;
 
 NewsNoteBook *nbook = new NewsNoteBook();
 
 tw->nbook = nbook;
 gtk_container_add (GTK_CONTAINER (tw->main_frame), nbook->get_widget());
 gtk_widget_show (nbook->get_widget());
 
 DownMode dmode;
 InfoSource *InS = create_netInfoSource(mode, NULL, 1, &dmode);
 
 RetrieveInfo *reader;
 switch(dmode) {
 case MFILE:
	 reader = new FileRetrieve(InS);
	 break;
 case MPROXY:
	 reader = new NetProxyRetrieve(InS);
	 break;
 case MNETWORK:
	 reader = new NetRetrieve(InS);
	 break;
 default:
	 reader = new FileRetrieve(InS);
 }
 
 NewsParser *parser = create_NewsParser(mode, reader);
 NewsList *li;

 BusyDialog *bd = new BusyDialog("Fetching the news...");
 
 li = parser->build_list();
 
 delete bd;

 gtk_widget_show ( GTK_WIDGET(tw->nbook->get_widget()) );
 ModifiablePage *newspage = new ModifiablePage("The News");
 newspage->add_news(li);
 
 delete parser;
 delete li;
 tw->get_notebook()->del_page("Main");
 tw->get_notebook()->add_page(newspage);

 
}

gint
on_combo_change_selection (GtkWidget *w, GdkEventKey *event, gpointer data)
{
  GTickerWindow *tw = (GTickerWindow *)data;

  if (event->keyval != GDK_Return ) return 0; 

  fetch_news ( tw );
  return 0;
}

gboolean
on_main_window_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_main_window_destroy_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  gtk_main_quit();
  return FALSE;
}


void
on_Preferences_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_Save_preferences_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_Quit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  
  gtk_main_quit();
}

/*
void
on_About_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}
*/

