
#include "Downloader.h"
#include "FreshmeatParser.h"
#include "SlashdotParser.h"
#include "SegFaultParser.h"
#include "LinuxTodayParser.h"
#include "KDENewsParser.h"
#include "LinuxAppsParser.h"
#include "BBCParser.h"
#include "CEOParser.h"
#include "SevenAMParser.h"
#include "ITNParser.h"
#include "GeekNewsParser.h"
#include "IceWalkersParser.h"
#include "LinuxDevParser.h"
#include "AppWatchParser.h"
#include "HotwiredParser.h"
#include "MozillaParser.h"

#include "NewsParsers.h"

#include "ctypes.h"
#include "util.h"
#include <stdlib.h>
#include <string.h>

char *Mode_name[] = {
	"Slashdot",
	"LinuxToday",
	"Segfault",
	"Freshmeat",
	"KDEnews",
	"LinuxApps",
	"BBC",
	"CEO",
	"7AM",
	"GeekNews",
	"IceWalkers",
	"Linuxdev",
	"AppWatch",
	"Hotwired",
	"Mozilla",
	NULL,
	"ITN"
};

Mode 
find_Mode(char *name) 
{
 Mode m;
 if (!name)
	 return (Mode)-1;
 if ( which_news_server(name, &m) == -1)  return (Mode)-1;
 return m;
}

GList *
get_servers_list()
{
 GList *glist = NULL;
 for (int i = 0; Mode_name[i]; i++) 
	 glist = g_list_append(glist, Mode_name[i]);
 return glist;

}


InfoSource *
create_netInfoSource(Mode mode, char *proxystr, int use_env, 
		     DownMode *dmode)
{
 InfoSource *InS;
 char *proxy_name = NULL;
 int  proxy_port = 0;

 if (use_env) 
	 parse_proxy_env( &proxy_name, &proxy_port );
 if ( proxystr ) {
	 if ( proxy_name ) free(proxy_name);
	 get_proxy_name(proxystr, &proxy_name, &proxy_port);
 }
 if ( proxy_name ) *dmode = MPROXY;
 else *dmode = MNETWORK;
 
 NewsParser *NP = create_NewsParser(mode, NULL);
 InS = new InfoSource ( NP->get_default_path(), NP->get_default_host(),
			proxy_name, NP->get_default_port(), proxy_port );
 delete NP;
 return InS;

}



int 
which_news_server ( char *optarg, Mode *mode )
{
 if ( !strcasecmp ( "slashdot", optarg ) ) 
	 *mode = SLASHDOT;
 else if ( !strcasecmp ( "freshmeat", optarg ) ) 
	 *mode = FRESHMEAT;
 else if ( !strcasecmp ( "linuxtoday", optarg ) ) 
	 *mode = LINUXTODAY;
 else if ( !strcasecmp ( "segfault", optarg ) ) 
	 *mode = SEGFAULT;      
 else if ( !strcasecmp ( "kdenews", optarg ) ) 
	 *mode = KDENEWS;
 else if ( !strcasecmp ( "linuxapps", optarg) )
	 *mode = LINUXAPPS;
 else if ( !strcasecmp ( "bbc", optarg ) )
	 *mode = BBC;
 else if ( !strcasecmp ( "ceo", optarg ) )
	 *mode = CEO;
 else if ( !strcasecmp ( "7am", optarg ) )
	 *mode = SEVENAM;
 else if ( !strcasecmp ( "GeekNews", optarg ) )
	 *mode = GEEKNEWS;
 else if ( !strcasecmp ( "IceWalkers", optarg ) )
	 *mode = ICEWALKERS;
 else if ( !strcasecmp ( "Linuxdev", optarg ) )
	 *mode = LINUXDEV; 
 else if ( !strcasecmp ( "AppWatch", optarg ) )
	 *mode = APPWATCH;
 else if ( !strcasecmp ( "Hotwired", optarg ) )
	 *mode = HOTWIRED;
 else if ( !strcasecmp ( "Mozilla", optarg ) )
	 *mode = MOZILLA;

 /*else if ( !strcasecmp ( "itn", optarg ) )
	 *mode = ITN;*/
 else { 
	 *mode = (Mode)-1;
	 return -1;
 }
 return 0;
 
} 



NewsParser *
create_NewsParser(Mode mode, RetrieveInfo *r)
{

 NewsParser *NP;
 switch(mode) {
 case FRESHMEAT:
	 NP = new FreshmeatParser(r);
	 break;
 case SEGFAULT:
	 NP = new SegFaultParser(r);
	 break;
 case SLASHDOT:
	 NP = new SlashdotParser(r);
	 break;
 case LINUXTODAY:
	 NP = new LinuxTodayParser(r);
	 break;
 case KDENEWS:
	 NP = new KDENewsParser(r);
	 break;
 case LINUXAPPS:
	 NP = new LinuxAppsParser(r);
	 break;
 case BBC:
	 NP = new BBCParser(r);
	 break;
 case CEO:
	 NP = new CEOParser(r);
	 break;
 case SEVENAM:
	 NP = new SevenAMParser(r);
	 break;
 case GEEKNEWS:
	 NP = new GeekNewsParser(r);
	 break;
 case ICEWALKERS:
	 NP = new IceWalkersParser(r);
	 break;
 case LINUXDEV:
	 NP = new LinuxDevParser(r);
	 break;
 case APPWATCH:
	 NP = new AppWatchParser(r);
	 break;
 case HOTWIRED:
	 NP = new HotwiredParser(r);
	 break;
 case MOZILLA:
	 NP = new MozillaParser(r);
	 break;
/* case ITN:
	 NP = new ITNParser(r);
	 break;*/
 default:
	 NP = new FreshmeatParser(r);
	 break;
 }
  
 return NP;

}

