
#include "Item.h"

#ifndef __NEWSLIST_H__
#define __NEWSLIST_H__

class NewsNode {
 private:
  Item *theitem;
  NewsNode *nextnode;
 public:
  NewsNode(Item *, NewsNode *); 
  NewsNode(const NewsNode &); /* copy constructor */
  NewsNode(const NewsNode *); // hace lo mismo
  ~NewsNode(); /* borra la copia del item que hemos hecho */
  /* construye nodo cuyo campo "next" es el puntero a NewsNode que le damos 
     tomamos el puntero a Item y NO lo guardamos tal cual, sino que lo 
     copiamos.
     DUPLICAMOS EL OBJETO!
   */

  void set_next(NewsNode *);
  NewsNode *get_next();
  Item *get_item();
};

class NewsList {
 protected:
  NewsNode *first;
  NewsNode *current;
  int number;

 public:
  NewsList(const NewsNode *); /* crea lista con primer nodo node */
  NewsList(); /* por defecto, inicializa lista a cero */
  ~NewsList();
  
  Item *get_first(); /* da el primero, pone iterador en el primer nodo */
  Item *get_next();  /* da el siguiente, avanza iterador */
  /* los punteros devueltos apuntan directamente al dato almacenado en la
     lista, no a una COPIA 
  */
  
  void insert(Item *); 
  /* inserta en la lista enlazada; hace una copia del objeto referenciado */
};



#endif
