
#ifdef HAVE_CONFIG_H
#    include <config.h>
#endif
#ifdef WITH_DMALLOC
#    include <dmalloc.h>
#endif

#include "NewsList.h"
#include <stdlib.h>
#include "debug.h"

NewsNode::NewsNode (Item *item, NewsNode *node)
{
  theitem = new Item(item);
  nextnode = node;
}

NewsNode::NewsNode (const NewsNode &ob)
{
  theitem = new Item (ob.theitem);
  nextnode = ob.nextnode;
}

NewsNode::NewsNode (const NewsNode *ob)
{
  theitem = new Item (ob->theitem);
  nextnode = ob->nextnode;
}

NewsNode::~NewsNode()
{
  delete theitem;
}


void NewsNode::set_next(NewsNode *n)
{
  nextnode = n;
}


NewsNode *NewsNode::get_next()
{
  return nextnode;
}

Item *NewsNode::get_item()
{
  return theitem;
}

/*
  NewsList methods
  Esta clase da las funcionalidades comunes de una lista enlazada.
  Como clase iteradora se puede usar como 
  for(NewsNode n=list.get_first(); n != NULL; n=get_next()) {
         // cosas bonitas
  }
 */


NewsList::NewsList(const NewsNode *node)
{
  number = ((node)? 1:0);
  first = new NewsNode(node);
  current = first;
}

NewsList::NewsList()
{
  first = current = NULL;
  number = 0;
}

Item *NewsList::get_first()
{
  current = first;
  if ( current == NULL ) 
    return NULL;
  return first->get_item();
}

Item *NewsList::get_next()
{
  if ( current == NULL ) 
    return NULL;
  current = current->get_next();
  if (current == NULL )
    return NULL;
  return current->get_item();
}

/*
  NewsList::insert(const Item *it)

  Se almacena una copia del item referenciado por el it.

*/
void NewsList::insert(Item *it)
{
  if (number == 0) {
    first = new NewsNode(it, NULL);
    number++;
    return;
  }
  NewsNode *nod;
  NewsNode *ins;
  /* lo siguiente recorre la lista hasta que lleguemos al ltimo */
  for(nod = first; nod->get_next() != NULL; nod = nod->get_next()) ;
  ins = new NewsNode( it, NULL );
  nod->set_next ( ins );
  number++;

  return;
}


NewsList::~NewsList()
{
  NewsNode *nod;
  NewsNode *t;
  
  if (!first)
    return;
  for (nod = first; nod; ) {
    t = nod;
    nod = nod->get_next();
    delete t;
  }

}
