#ifdef HAVE_CONFIG_H
#    include <config.h>
#endif
#ifdef WITH_DMALLOC
#    include <dmalloc.h>
#endif

#include "Item.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

char *data[][2] = {
  "title", "This is a test.",
  "name",  "Herr Puntila",
  "naem",  "test",
  "maen",  "bla bla",
  "mean",  "sounds awful in spanish",
  "eman",  "just to see if the hash func works OK",
  "cdate", "1999-27-07",
  "link",  "/SiliconValley/Vista/2075/new/asNews.html",
  "date",  "Jul 27 1999",
  "site",  "Segfault",
  "author","anonymous coward"
};

#define NUM 11

static void  display (gpointer, gpointer, gpointer);

class SimpleC: public Cloneable {
 SimpleC() { };
 public:
 int one_int;
 char *one_str;
 
 SimpleC(char *s, int i) { one_str = strdup(s); one_int = i;}
 SimpleC(const SimpleC &o) { 
	 one_str = strdup ( o.one_str );
	 one_int = o.one_int;
 }
 SimpleC(const SimpleC *o) {
	 one_str = strdup ( o->one_str );
	 one_int = o->one_int;
 }
 ~SimpleC() { destroy(); }
 void destroy() { free(one_str); }
 Cloneable *clone() { return new SimpleC(this); }
};

void display_SimpleC ( gpointer key, 
		       gpointer value, gpointer data )
{
  SimpleC *t;
  t = (SimpleC *)value;
  fprintf ( (FILE *)data, "Key: %s\t\tValue: (\"%s\",%d)\n",
	    (char *) key, t->one_str, t->one_int ); 

}

void 
display (gpointer key, 
	 gpointer value, gpointer data)
{
  fprintf ( (FILE *)data, "Key: %s\t\t Data: %s\n", (char *)key, (char *)value);

}


int main(int argc, char *argv[])
{
  Item *test;

  test = new Item();

  printf ( "Testing the hash function.\n\n" );
  for (int i=0; i<NUM; i++) {
	  printf ( "String %s, \t\tHash value: 0x%2x\t(%d)\n", data[i][0], 
		   str_hash(data[i][0]) , str_hash(data[i][0]) );
  }
  printf ("\n");
  char *t = (char *)malloc(2048); /* just to get a memory leak */
  t = t; /* to avoid "variable declared but not used" with -Wall */
  /* to test if dmalloc is configured OK. */

  for (int i=0; i<NUM; i++) {
    test->insert_field ( data[i][0], data[i][1] );
  }
  test->print(stdout);

  printf ("\nDeleting elements name, eman, popo and date\n\n");
  test->delete_field ( "name" );
  test->delete_field ( "popo" );
  test->delete_field ( "date" );
  test->delete_field ( "eman" );
  
  test->foreach( display, stdout);
  printf ( "\nTesting copy constructor.\n\n");

  Item *nt = new Item(test);
  nt->print(stdout);
	
  nt->insert_field ( "ID", "nt: copied from test (copy constructor)");
  test->insert_field ( "ID", "ORIGINAL" );

  delete nt;
  delete test;

  printf ("\nTesting GenericHash.\n\n");
  
  GenericHash *a = new GenericHash();
  for (int i=0; i<NUM; i++) {
	  SimpleC insert(data[i][1], strlen(data[i][1]));
	  printf ( "Inserting field: %s\tVALUE: (\"%s\",%d)\n", 
		   data[i][0], data[i][1], strlen(data[i][1]) );
	  a->insert_field ( data[i][0], &insert );
  }
  
    
  printf ("\nDeleting elements name, title, eman, popo and date\n\n");
  a->delete_field ( "name" );
  a->delete_field ( "popo" );
  a->delete_field ( "date" );
  a->delete_field ( "eman" );
  a->delete_field ( "title" );
  
  for (int i=0; i<NUM; i++) {
	  SimpleC *poin =  (SimpleC *)a->get_field(data[i][0]);
	  if (poin) 
		  printf ("Reading field: %s, value: (\"%s\", %d)\n", 
			  data[i][0], poin->one_str, poin->one_int);
  }
  printf ( "\nTesting copy constructor.\n\n");

  GenericHash *gcopied = new GenericHash(a);
 
  gcopied->foreach ( display_SimpleC, stdout );

  delete a;
  delete gcopied;

}
