
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#ifndef __NEWS_H__
#define __NEWS_H__


class Cloneable { 
 public:
 Cloneable() { }
 Cloneable(const Cloneable &) { }
 Cloneable(const Cloneable *) { }
 virtual ~Cloneable() { destroy(); }
 virtual void destroy() { }
 virtual Cloneable *clone() { return new Cloneable(this); }
 //virtual bool operator==(const Cloneable& o1) { return false; }
};


class Item: public Cloneable {
 private:
  GHashTable *hash;
  
 public:

  char *get_field(char *);
  int  insert_field(char *, char *); 
  int  delete_field(char *);
  int  count_fields();
  void foreach ( void (*)(gpointer, gpointer, gpointer), void * );
  Item(const Item &);
  Item();
  Item(const Item *); 
  ~Item();
  void destroy() { delete this; }
  Cloneable *clone() { return new Item(this); }
  void print(FILE *);
};

struct TwoStrings {
	char *key;
	char *value;
};

class HashValue: Cloneable {
 private:
 HashValue() { };
 public:
 Cloneable *value;
 char *key;
 HashValue(char *name, Cloneable *ob) { 
	 key = strdup(name); value = ob->clone();
 }
 HashValue(const HashValue &ob) { 
	 key = strdup (ob.key); value = ob.value->clone();
 }
 HashValue(const HashValue *ob) {
	 key = strdup (ob->key); value = ob->value->clone();
 }
 ~HashValue() { destroy(); }
 void destroy() { free(key); delete value; }
 Cloneable *clone() { return new HashValue(this); }
};

/* Yes it'd be good to use a template for all this stuff, but 
   templates work real bad in GNU G++ and give some problems
   (automatic template instantiation) with EGCC. So we do
   all this Java-like... starting with the Cloneable class :) 
*/
class GenericHash: public Cloneable {
 private:
  GHashTable *hash;

 public:

  Cloneable *get_field(char *);
  int  insert_field(char *, Cloneable *);
  int  delete_field(char *);
  int  count_fields();
  void foreach ( void (*)(gpointer, gpointer, gpointer), void * );
  GenericHash(const GenericHash &);
  GenericHash();
  GenericHash(const GenericHash *);
  ~GenericHash() { destroy(); }
  void destroy();
  Cloneable *clone() { return new GenericHash(this);}
};

guint str_hash (gpointer);


#endif
