
#include "NewsList.h"
#include <string.h>
#include <stdlib.h>

#ifndef __DOWNLOADER_H__
#define __DOWNLOADER_H__

class InfoSource {
 public:
  char *filename;
  char *site;
  char *proxy;
  int port;
  int proxy_port;
  
  InfoSource(char *Filename, char *Site, char *Proxy, int Port, int PPort);
  InfoSource(const InfoSource &i) {
    if (i.filename) filename = strdup(i.filename);
    else filename = NULL;
    if (i.site) site = strdup(i.site);
    else site = NULL;
    if (i.proxy) proxy = strdup(i.proxy);
    else proxy = NULL;
    port = i.port;
    proxy_port = i.proxy_port;
  }
  ~InfoSource() {
    if (filename)
      free (filename);
    if (site) 
      free (site);
    if (proxy)
      free (proxy);
  }
};


class RetrieveInfo {
 protected:
  InfoSource *insource;
 public:
  RetrieveInfo(InfoSource *in) { insource = in; }
  virtual int retrieve() { return -1; }
  virtual char *get_data() { return NULL; }
  virtual int get_size() { return 0; }
  virtual ~RetrieveInfo() { delete insource; }
};

class FileRetrieve: public RetrieveInfo {
  char *buf;
  int bytesread;

 public:
  FileRetrieve(InfoSource *in): RetrieveInfo(in) { buf = NULL; }
  int get_size();
  char *get_data();
  int retrieve();
  ~FileRetrieve();
};

class NetRetrieve: public RetrieveInfo {  
  char *buf;
  int bytesread;
  int twonls(char *pt);
 public:
  NetRetrieve(InfoSource *in): RetrieveInfo(in) { buf = NULL; }
  int retrieve();
  char *get_data();
  int get_size();
  ~NetRetrieve() { if (buf) delete buf; }
};

class NetProxyRetrieve: public RetrieveInfo {
  char *buf;
  int bytesread;
  int twonls(char *pt);

 public:
  NetProxyRetrieve(InfoSource *in): RetrieveInfo(in) { buf = NULL;}
  int retrieve();
  char *get_data();
  int get_size();
  ~NetProxyRetrieve() { if (buf) free( buf ); }
};

class NewsParser {
 protected:
  RetrieveInfo *retr;
  char *_dhost;
  int _dport;
  char *_dpath;
  char *_name;
 public:
  char *get_default_host() { return _dhost; }
  char *get_default_path() { return _dpath; }
  char *get_name() { return _name; }
  int  get_default_port() { return _dport; }
  NewsParser(RetrieveInfo *r) {
	  retr = r; _name="News"; _dpath=NULL; _dhost=NULL; _dport=0;
  }
  virtual NewsList *build_list() { return NULL;}
  virtual ~NewsParser() { if (retr) delete retr; };
};


#endif
