/************************************************************************
 * $Id: Downloader.cc,v 2.13 1999/12/30 22:26:02 batsman Exp $
************************************************************************/

/*****************************************************************************
==============================================================================
    asNews --- retrieves news from the net and shows them in your desktop
    Copyright (C) 1998-1999 Mauricio Julio Fernndez Pradier

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
==============================================================================
*****************************************************************************/

#ifdef HAVE_CONFIG_H
#    include <config.h>
#endif
#ifdef WITH_DMALLOC
#  include <dmalloc.h>
#endif

#include "Downloader.h"
#include "NewsList.h"
#include "Item.h"
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <netdb.h>
#include <unistd.h>
#include "common.h"
#include "debug.h"
#include "log.h"

#define PUERTO_TCP 80
#define SIZEOFBUF 65534


/**************************************************************************
***************************************************************************
 
                          InfoSource  METHODS

***************************************************************************
***************************************************************************/

InfoSource::InfoSource(char *Filename, char *Site, 
		       char *Proxy, int Port, int PPort)
{
  if (Filename) 
	this->filename = strdup (Filename);
  else 
    this->filename = NULL;
  
  if (Site)
    this->site = strdup (Site);
  else 
    this->site = NULL;
  
  if (Proxy)
    this->proxy = strdup (Proxy);
  else 
    this->proxy = NULL;
  
  this->port = Port;
  this->proxy_port = PPort;
}




/**************************************************************************
***************************************************************************
 
                          NetRetrieve  METHODS

***************************************************************************
***************************************************************************/


char *
NetRetrieve::get_data()
{
  return buf;
}

int 
NetRetrieve::get_size()
{
  return bytesread;
}

int 
NetRetrieve::twonls(char *pt)
{
  if ( *pt == '\n' && *(pt+1) == '\n' )
    return 2;
  if ( pt[0] == '\r' && pt[1] == '\n' 
       && pt[2] == '\r' && pt[3] == '\n' )
    return 4;
  return 0;
}


int
NetRetrieve::retrieve()
{
  buf = NULL;
  
   /* fresh mem for news */
  buf = new char[SIZEOFBUF]; 

  int sock = socket ( AF_INET, SOCK_STREAM, 0);
  /* TODO: SIGNAL ERROR */
  if ( sock == -1 ) {
    delete [] buf;
    buf = NULL;
    return -1;
  }
  
  struct sockaddr_in server_addr;

  server_addr.sin_family = AF_INET;
  
  struct hostent *host;
  host = gethostbyname ( insource->site );
  if ( host == NULL ) {
    delete [] buf;
    log_error("Can't find host %s.", insource->site );
    buf = NULL;
    return -1;
  }
  server_addr.sin_addr.s_addr = *(long *)host->h_addr;
  /* TODO: CHECK FOR ERRORS */
  server_addr.sin_port = htons (insource->port);

  if ( connect( sock, 
		(struct sockaddr *)&server_addr, 
		sizeof(struct sockaddr_in) ) == -1 ) {
    delete [] buf;
    log_error ( "Could not connect to host %s.", insource->site );
    buf = NULL;
    return -1;
  }
  
  char demand[2048];
  sprintf ( demand, 
	    "GET %s HTTP/1.0\n"
	    "User-Agent: Mozilla/3.01Gold (Macintosh; I; 68K)\n"
	    "Accept-Language: en\n"
	    "Accept-Charset: iso-8859-1,*,utf-8\n"
	    "Host: %s:%d\n\n",
	    insource->filename, insource->site, insource->port);

  if (verbose )
    log_msg ( "Making HTTP/1.0 request.");
  if (verbose >= 2)
    log_msg_long ( "Request: %s", demand );
  write (sock, demand, strlen(demand));

  bytesread = 0;
  if (verbose)
    log_msg ( "Receiving data." );
  while ( 1 ) {
    fd_set rfds;
    struct timeval tv;
    int retval;
    
    FD_ZERO(&rfds);
    FD_SET(sock, &rfds);
    /* Wait up to five seconds. */
    tv.tv_sec = 10;
    tv.tv_usec = 0;
    
    retval = select(sock + 1, &rfds, NULL, NULL, &tv);
    /* Don't rely on the value of tv now! */
    
    if (!retval) 
      break;

    int rvalue = read (sock, buf+bytesread, SIZEOFBUF-bytesread);
      
    if ( rvalue == -1 ) {
      delete [] buf;
      buf = NULL;
      return -1;
    }
    bytesread += rvalue;
    if (rvalue == 0)
	break;
  }
  buf[bytesread] = '\0';

  if(bytesread == 0) {
    close(sock);
    log_error ( "The server ignored our request. Try again.");
    return -1;
  }

  char pt[3];
  pt[0] = buf[9];
  pt[1] = buf[10];
  pt[2] = buf[11];
  
  int status = atoi(pt);
  if (status!=200 && status!=302 ) {
    char *p;
    for(p = buf; *p!='\n' && *p && *p!='\r'; p++) /* do nothing */ ; 
    *p = '\0';
    log_error_long ( "Data transmission failed.\n"
		     " HTTP reply: %s.", buf);
    bytesread = 0;
    delete [] buf;
    buf = NULL;
    return -1;
  }
  
  char *str = buf;
  int nlsiz = 0;
  for ( ; !(nlsiz = twonls(str)); str++) /* do nothing */;
  str += nlsiz; //skip both \n's
  char *bak = (char *)malloc ( strlen(str) +1);
  strcpy(bak, str);
  delete [] buf;
  buf = bak;

  if ( verbose >= 5 ) 
	  log_msg_long ("Received data: %s", buf );
  bytesread = strlen ( buf );
  close ( sock );
  return 0;
}




/**************************************************************************
***************************************************************************
 
                          FileRetrieve  METHODS

***************************************************************************
***************************************************************************/

int
FileRetrieve::retrieve()
{
  FILE *in;
  if ( (in = fopen(insource->filename, "r")) == NULL ) {
    log_error ( "Could not open file %s.", insource->filename);
    buf = NULL;
    bytesread = 0;
    return -1; 
  }
  int size;
  fseek ( in, 0, SEEK_END); /* TODO: check errors */
  size = ftell (in);

  if (verbose)
    log_msg( "Reading file %s.", insource->filename);

  rewind (in);
  buf = (char *) malloc ( size + 1 ); /* TODO: check malloc errors */
  fread ( buf, size, 1, in );
  buf[size] = '\0';
  fclose (in);

  if ( verbose >= 5 ) 
	  log_msg_long ("Received data: %s", buf );

  bytesread = strlen ( buf);
  return 0;

}


char *
FileRetrieve::get_data()
{
  return buf;
}

int 
FileRetrieve::get_size()
{
  return bytesread;
}

FileRetrieve::~FileRetrieve()
{
  if (buf )
    free (buf);
}



/**************************************************************************
***************************************************************************
 
                          NetProxyRetrieve  METHODS

***************************************************************************
***************************************************************************/


char *
NetProxyRetrieve::get_data()
{
  return buf;
}

int 
NetProxyRetrieve::get_size()
{
  return bytesread;
}

int 
NetProxyRetrieve::twonls(char *pt)
{
  if ( *pt == '\n' && *(pt+1) == '\n' )
    return 2;
  if ( pt[0] == '\r' && pt[1] == '\n' 
       && pt[2] == '\r' && pt[3] == '\n' )
    return 4;
  return 0;
}

int
NetProxyRetrieve::retrieve()
{
  buf = NULL;
  
  /* fresh mem for news */
  buf = new char[SIZEOFBUF]; 
  
  int sock = socket ( AF_INET, SOCK_STREAM, 0);
  /* TODO: SIGNAL ERROR */
  if ( sock == -1 ) {
    delete [] buf;
    buf = NULL;
    return -1;
  }
  
  struct sockaddr_in server_addr;
  
  server_addr.sin_family = AF_INET;
  
  struct hostent *host;
  host = gethostbyname ( insource->proxy );
  if ( host == NULL ) {
    delete [] buf;
    log_error ( "Can't find host %s.", insource->proxy );
    buf = NULL;
    return -1;
  }
  server_addr.sin_addr.s_addr = *(long *)host->h_addr;
  /* TODO: CHECK FOR ERRORS */
  server_addr.sin_port = htons (insource->proxy_port);
  
  if ( connect( sock, 
	      (struct sockaddr *)&server_addr, 
		sizeof(struct sockaddr_in) ) == -1 ) {
    delete [] buf;
    log_error ( "Could not connect to host %s.", insource->proxy );
    buf = NULL;
    return -1;
  }
  
  char demand[2048];
  sprintf ( demand, 
	    "GET http://%s:%d%s HTTP/1.0\n"
	    "User-Agent: Mozilla/3.01Gold (Macintosh; I; 68K)\n"
	    "Accept-Language: en\n"
	    "Accept-Charset: iso-8859-1,*,utf-8\n\n",
	    insource->site, insource->port, insource->filename);
  
  
  if (verbose )
    log_msg ( "Making HTTP/1.0 request.");
  if (verbose >= 2)
    log_msg_long ( "Request: %s", demand );

  write (sock, demand, strlen(demand));
  
  if (verbose)
    log_msg ( "Receiving data." );
  bytesread = 0;
  while ( 1 ) {
    fd_set rfds;
    struct timeval tv;
    int retval;
    
    FD_ZERO(&rfds);
    FD_SET(sock, &rfds);
    /* Wait up to five seconds. */
    tv.tv_sec = 10;
    tv.tv_usec = 0;
    
    retval = select(sock + 1, &rfds, NULL, NULL, &tv);
    /* Don't rely on the value of tv now! */
    
    if (!retval) 
      break;

    int rvalue = read (sock, buf+bytesread, SIZEOFBUF-bytesread);
    
    if ( rvalue == -1 ) {
      delete [] buf;
      buf = NULL;
      return -1;
    }
    bytesread += rvalue;
    if (rvalue == 0)
      break;
  }
  buf[bytesread] = '\0';
  
  if (bytesread == 0) {
    close(sock);
    log_error ( "The proxy is ignoring our request. Try again.");
    return -1;
  }

  char pt[3];
  pt[0] = buf[9];
  pt[1] = buf[10];
  pt[2] = buf[11];
  
  int status = atoi(pt);
  if (status!=200 && status!=302) {
    char *p;
    for(p = buf; *p!='\n' && *p && *p!='\r'; p++) /* do nothing */ ; 
    *p = '\0';
    log_error_long ( "Data transmission from proxy failed.\n"
		     " HTTP reply: %s.", buf);
    bytesread = 0;
    delete [] buf;
    buf = NULL;
    return -1;
  }
  
  char *str = buf;
  int nlsiz = 0;
  for ( ; !(nlsiz = twonls(str)); str++) /* do nothing */;
  str += nlsiz; //skip both \n's
  char *bak = (char *)malloc ( strlen(str) +1);
  strcpy(bak, str);
  delete [] buf;
  buf = bak;

  if ( verbose >= 5 ) 
	  log_msg_long ("Received data: %s", buf );
  
  bytesread = strlen ( buf );
  close ( sock );
  return 0;
}


