
/*****************************************************************************
==============================================================================
    asNews --- retrieves news from the net and shows them in your desktop
    Copyright (C) 1998-1999 Mauricio Julio Fernndez Pradier

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
==============================================================================
*****************************************************************************/

#ifdef HAVE_CONFIG_H
#    include <config.h>
#endif
#ifdef WITH_DMALLOC
#    include <dmalloc.h>
#endif

#include "CreateFile.h"
#include "Item.h"
#include "NewsList.h"
#include "debug.h"
#include "log.h"
#include "common.h"

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

/*
  name es el nombre del directorio, Item es una entrada
*/
int ASFile::do_file(char *name, Item *it)
{
  char txt[5000];
  snprintf( txt, 5000, 
	   "Exec \"%s\" exec netscape -remote 'openURL(%s)' &\n",
	   it->get_field("title"), it->get_field("link"));
  char *filename;
  filename = (char *) malloc(strlen(it->get_field("title")) 
			     + strlen(name) + 2);
  if( name[strlen(name) - 1] == '/' ) {
    strcpy( filename, name );
    strcat( filename, it->get_field("title") );
  }
  else {
    strcpy( filename, name );
    strcat( filename, "/" );
    strcat( filename, it->get_field("title") );
  }

  FILE *out;
  if( (out = fopen ( filename, "w" )) == NULL ) {
	  /*fprintf (stdout, "Error: Could not open file %s.\n", filename );*/
	  free(filename);
	  return -1;
  }
  if (verbose>=2)
	  log_msg ( "Writing AfterStep menu entry to file %s.", filename);
  if(fwrite ( txt, strlen(txt), 1, out) == 0 ) {
	  log_error ("Could not write to file %s.", filename);
	  fclose (out);
	  free(filename);
	  return -1;
  }
  free(filename);
  fclose (out);
  return 0;
}


int ASFile::do_file(char *name, NewsList *list)
{
 int status = 0;
  for ( Item *it = list->get_first(); it!= NULL; it=list->get_next() )
	  status |= do_file(name, it);
  return status;
}


int KDEFile::do_file(char *name, NewsList *list)
{
 int status = 0;
  for ( Item *it = list->get_first(); it!= NULL; it=list->get_next() )
	  status |= do_file(name, it);  
  return status;
}



int KDEFile::do_file(char *name, Item *it)
{
  char txt[5000];
  snprintf( txt, 5000, 
           "# KDE Config File\n[KDE Desktop Entry]\n
           URL=%s\nIcon=www.xpm\nType=Link\nName=%s\n",
           it->get_field("link"), it->get_field("title"));
  char *filename;
  filename = (char *) malloc(strlen(it->get_field("title")) 
			     + strlen(name) + strlen(".kdelnk") + 2);
  if( name[strlen(name) - 1] == '/' ) {
    strcpy( filename, name );
    strcat( filename, it->get_field("title") );
    strcat( filename, ".kdelnk" );
  }
  else {
    strcpy( filename, name );
    strcat( filename, "/" );
    strcat( filename, it->get_field("title") );
    strcat( filename, ".kdelnk" );
  }

  FILE *out;
  if( (out = fopen ( filename, "w" )) == NULL ) {
    free(filename);
    return -1;
  }
  if (verbose>=2)
	  log_msg ( "Writing KDE direct link to file %s.", filename);

  if(fwrite ( txt, strlen(txt), 1, out) == 0 ) {
	  log_error ("Could not write to file %s.", filename);
	  fclose (out);
	  free(filename);
	  return -1;
  }
  free(filename);
  fclose (out);
  return 0;
}
