/*  BrowseMenu -*- mode: linux-c -*-
 *  Copyright (C) 1999 Mauricio Julio Fernndez Pradier
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "config.h"
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "BrowseMenu.h"
#include <string.h>
#include <stdio.h>

BrowseMenu::BrowseMenu (char *url)
{
 URL = strdup(url);


 browse_menu = gtk_menu_new ();
 gtk_object_set_data (GTK_OBJECT (browse_menu), "browse_menu", browse_menu);
 gtk_container_border_width (GTK_CONTAINER (browse_menu), 2);

 View_with_Netscape = gtk_menu_item_new_with_label ("View with Netscape");
 gtk_object_set_data (GTK_OBJECT (browse_menu), "View_with_Netscape", View_with_Netscape);
 gtk_widget_show (View_with_Netscape);
 gtk_menu_append (GTK_MENU (browse_menu), View_with_Netscape);
 gtk_signal_connect (GTK_OBJECT (View_with_Netscape), "activate",
		     GTK_SIGNAL_FUNC (on_View_with_Netscape_activate),
		     this);
  
 View_with_Lynx = gtk_menu_item_new_with_label ("View with Lynx");
 gtk_object_set_data (GTK_OBJECT (browse_menu), "View_with_Lynx", View_with_Lynx);
 gtk_widget_show (View_with_Lynx);
 gtk_menu_append (GTK_MENU (browse_menu), View_with_Lynx);
 gtk_signal_connect (GTK_OBJECT (View_with_Lynx), "activate",
		     GTK_SIGNAL_FUNC (on_View_with_Lynx_activate),
		     this);
  
 View_with_w3m = gtk_menu_item_new_with_label ("View with w3m");
 gtk_object_set_data (GTK_OBJECT (browse_menu), "View_with_w3m", View_with_w3m);
 gtk_widget_show (View_with_w3m);
 gtk_menu_append (GTK_MENU (browse_menu), View_with_w3m);
 gtk_signal_connect (GTK_OBJECT (View_with_w3m), "activate",
		     GTK_SIGNAL_FUNC (on_View_with_w3m_activate),
		     this);

}



/*

  SIGNAL FUNCTIONS

*/


void
on_View_with_Netscape_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  BrowseMenu *br = (BrowseMenu *)user_data;
 char *url = br->URL;
 /* call netscape */
 char str[512];
 sprintf ( str, "netscape -remote 'openURL(%s)' &", url);
 system ( str );
 
 delete br;

}


void
on_View_with_Lynx_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 BrowseMenu *br = (BrowseMenu *)user_data;
 char *url = br->URL;
 /* call lynx */
 char str[512];
 sprintf ( str, "xterm -e lynx %s &", url);
 system ( str );
 
 delete br;

}


void
on_View_with_w3m_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

 BrowseMenu *br = (BrowseMenu *)user_data;
 char *url = br->URL;
 /* call w3m */
 char str[512];
 sprintf ( str, "xterm -e w3m %s &", url);
 system ( str );
 
 delete br;

}
